/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.storage;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.alchemy.CardCaptchas;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.entry.PostEntryTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MSExtraData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "minestuck_extra";
    private final List<EditData> activeEditData = new ArrayList<EditData>();
    private final Map<UUID, EditData.PlayerRecovery> editPlayerRecovery = new HashMap<UUID, EditData.PlayerRecovery>();
    private final List<EditData.ConnectionRecovery> editConnectionRecovery = new ArrayList<EditData.ConnectionRecovery>();
    private final CardCaptchas cardCaptchas = new CardCaptchas();
    private final List<PostEntryTask> postEntryTasks = new ArrayList<PostEntryTask>();

    private MSExtraData() {
    }

    public static MSExtraData load(CompoundTag nbt) {
        MSExtraData data = new MSExtraData();
        data.activeEditData.clear();
        data.editPlayerRecovery.clear();
        data.editConnectionRecovery.clear();
        data.postEntryTasks.clear();
        ListTag editRecoveryList = nbt.getList("editmode_recovery", 10);
        for (int i = 0; i < editRecoveryList.size(); ++i) {
            CompoundTag dataTag = editRecoveryList.getCompound(i);
            UUID playerID = dataTag.getUUID("player");
            data.editPlayerRecovery.put(playerID, EditData.readRecovery(dataTag));
            EditData.ConnectionRecovery recovery = EditData.readExtraRecovery(dataTag);
            if (recovery == null) continue;
            data.editConnectionRecovery.add(recovery);
        }
        ListTag entryTaskList = nbt.getList("entry_tasks", 10);
        for (int i = 0; i < entryTaskList.size(); ++i) {
            PostEntryTask.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)entryTaskList.getCompound(i)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(data.postEntryTasks::add);
        }
        if (nbt.contains("card_captchas", 10)) {
            data.cardCaptchas.deserialize(nbt.getCompound("card_captchas"));
        }
        return data;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        ListTag editRecoveryList = new ListTag();
        editRecoveryList.addAll(this.editPlayerRecovery.entrySet().stream().map(MSExtraData::writeRecovery).toList());
        editRecoveryList.addAll(this.activeEditData.stream().map(MSExtraData::writeRecovery).toList());
        compound.put("editmode_recovery", (Tag)editRecoveryList);
        ListTag entryTaskList = new ListTag();
        this.postEntryTasks.stream().flatMap(task -> PostEntryTask.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, task).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).stream()).forEach(arg_0 -> entryTaskList.add(arg_0));
        compound.put("entry_tasks", (Tag)entryTaskList);
        compound.put("card_captchas", (Tag)this.cardCaptchas.serialize());
        return compound;
    }

    private static CompoundTag writeRecovery(EditData data) {
        CompoundTag nbt = data.writeRecoveryData();
        nbt.putUUID("player", data.getEditor().getGameProfile().getId());
        return nbt;
    }

    private static CompoundTag writeRecovery(Map.Entry<UUID, EditData.PlayerRecovery> data) {
        CompoundTag nbt = data.getValue().write(new CompoundTag());
        nbt.putUUID("player", data.getKey());
        return nbt;
    }

    public static MSExtraData get(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            throw new IllegalArgumentException("Can't get extra data instance on client side! (Got null server from level)");
        }
        return MSExtraData.get(server);
    }

    public static MSExtraData get(MinecraftServer mcServer) {
        ServerLevel level = mcServer.getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = level.getDataStorage();
        return (MSExtraData)storage.computeIfAbsent(new SavedData.Factory(MSExtraData::new, (tag, provider) -> MSExtraData.load(tag)), DATA_NAME);
    }

    @Nullable
    public EditData findEditData(Predicate<EditData> condition) {
        for (EditData data : this.activeEditData) {
            if (!condition.test(data)) continue;
            return data;
        }
        return null;
    }

    public void addEditData(EditData data) {
        this.activeEditData.add(data);
        this.setDirty();
    }

    public void removeEditData(EditData data) {
        if (this.activeEditData.remove(data)) {
            this.setDirty();
        }
    }

    public void forEach(Consumer<EditData> consumer) {
        this.activeEditData.forEach(consumer);
    }

    public void forEachAndClear(Consumer<EditData> consumer) {
        if (!this.activeEditData.isEmpty()) {
            this.forEach(consumer);
            this.activeEditData.clear();
            this.setDirty();
        }
    }

    public EditData.PlayerRecovery removePlayerRecovery(UUID playerID) {
        EditData.PlayerRecovery recovery = this.editPlayerRecovery.remove(playerID);
        if (recovery != null) {
            this.setDirty();
        }
        return recovery;
    }

    public void recoverConnections(MinecraftServer mcServer) {
        if (!this.editConnectionRecovery.isEmpty()) {
            LOGGER.warn("Recovering extra connection data for {} players that were in editmode when the server shut down abruptly last session. An attempt to recover players will be made when they rejoin the server.", (Object)this.editConnectionRecovery.size());
            this.editConnectionRecovery.forEach((? super T recovery) -> recovery.recover(mcServer));
            this.editConnectionRecovery.clear();
            this.setDirty();
        }
    }

    public void addPostEntryTask(PostEntryTask task) {
        this.postEntryTasks.add(task);
        this.setDirty();
    }

    public void executeEntryTasks(MinecraftServer server) {
        for (PostEntryTask task : this.postEntryTasks) {
            if (!task.onTick(server)) continue;
            this.setDirty();
        }
        if (this.postEntryTasks.removeIf(PostEntryTask::isDone)) {
            this.setDirty();
        }
    }

    public CardCaptchas getCardCaptchas() {
        return this.cardCaptchas;
    }

    public boolean isDirty() {
        return super.isDirty() || !this.activeEditData.isEmpty();
    }
}

