/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.storage;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportalizerSavedData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "minestuck_transportalizers";
    private final Map<String, GlobalPos> locations = new HashMap<String, GlobalPos>();

    private TransportalizerSavedData() {
    }

    private static TransportalizerSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        TransportalizerSavedData data = new TransportalizerSavedData();
        data.locations.clear();
        for (String id : nbt.getAllKeys()) {
            Tag locationTag = nbt.get(id);
            GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)locationTag).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(location -> data.locations.put(id, (GlobalPos)location));
        }
        return data;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        for (Map.Entry<String, GlobalPos> entry : this.locations.entrySet()) {
            GlobalPos location = entry.getValue();
            GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)location).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(locationTag -> compound.put((String)entry.getKey(), locationTag));
        }
        return compound;
    }

    public GlobalPos get(String id) {
        return this.locations.get(id);
    }

    public boolean set(String id, GlobalPos location) {
        if (!this.locations.containsKey(id)) {
            this.locations.put(id, location);
            this.setDirty();
            return true;
        }
        return this.locations.get(id).equals((Object)location);
    }

    public boolean remove(String id, GlobalPos location) {
        boolean removed = this.locations.remove(id, location);
        if (removed) {
            this.setDirty();
        }
        return removed;
    }

    public void replace(String id, GlobalPos oldPos, GlobalPos newPos) {
        if (this.locations.replace(id, oldPos, newPos)) {
            this.setDirty();
        }
    }

    public static TransportalizerSavedData get(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            throw new IllegalArgumentException("Can't get transportalizer data instance on client side! (Got null server from level)");
        }
        return TransportalizerSavedData.get(server);
    }

    public static TransportalizerSavedData get(MinecraftServer mcServer) {
        ServerLevel level = mcServer.getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = level.getDataStorage();
        return (TransportalizerSavedData)storage.computeIfAbsent(new SavedData.Factory(TransportalizerSavedData::new, TransportalizerSavedData::load), DATA_NAME);
    }
}

