/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public record SendManyChunksPacket(ResourceKey<Level> dimension, UUID teamId, List<ChunkSyncInfo> chunks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendManyChunksPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("send_many_chunks_packet"));
    public static final StreamCodec<FriendlyByteBuf, SendManyChunksPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), SendManyChunksPacket::dimension, (StreamCodec)UUIDUtil.STREAM_CODEC, SendManyChunksPacket::teamId, (StreamCodec)ChunkSyncInfo.STREAM_CODEC.apply(ByteBufCodecs.list()), SendManyChunksPacket::chunks, SendManyChunksPacket::new);

    public void sendToAll(MinecraftServer server, ChunkTeamData teamData) {
        if (teamData.shouldHideClaims()) {
            SendManyChunksPacket hiddenPacket = this.hidden();
            Iterator iterator = server.getPlayerList().getPlayers().iterator();
            while (iterator.hasNext()) {
                ServerPlayer player;
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)(teamData.isAlly((player = (ServerPlayer)iterator.next()).getUUID()) ? this : hiddenPacket));
            }
        } else {
            NetworkManager.sendToPlayers((Iterable)server.getPlayerList().getPlayers(), (CustomPacketPayload)this);
        }
    }

    public void sendToPlayer(ServerPlayer player, ChunkTeamData teamData) {
        if (teamData.shouldHideClaims()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)(teamData.isAlly(player.getUUID()) ? this : this.hidden()));
        } else {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this);
        }
    }

    public SendManyChunksPacket hidden() {
        return new SendManyChunksPacket(this.dimension(), Util.NIL_UUID, this.chunks().stream().map(ChunkSyncInfo::hidden).toList());
    }

    public CustomPacketPayload.Type<SendManyChunksPacket> type() {
        return TYPE;
    }

    public static void handle(SendManyChunksPacket message, NetworkManager.PacketContext context) {
        context.queue(() -> FTBChunksClient.INSTANCE.updateChunksFromServer(message.dimension, message.teamId, message.chunks));
    }
}

