/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.block;

import com.dweb.paldelight.block.PDBlocks;
import com.dweb.paldelight.item.PDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class OliveLeaves
extends LeavesBlock {
    public static final BooleanProperty FRUITING = PDBlocks.FRUITING;

    public OliveLeaves(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FRUITING, (Comparable)Boolean.valueOf(false))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.random.nextFloat() <= 0.025f && this.airExposed((Level)level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FRUITING, (Comparable)Boolean.valueOf(true)), 3);
        }
        super.randomTick(state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)FRUITING)).booleanValue()) {
            OliveLeaves.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)PDItems.OLIVE.get()));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 0.5f, 1.3f);
            level.setBlock(pos, (BlockState)state.setValue((Property)FRUITING, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean airExposed(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState iterateState;
            if (direction.equals((Object)Direction.UP) || !(iterateState = level.getBlockState(pos.relative(direction))).isAir() && !iterateState.canBeReplaced()) continue;
            return true;
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return 5;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FRUITING});
    }
}

