/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.block;

import com.dweb.paldelight.block.OliveLeaves;
import com.dweb.paldelight.block.PDLogBlock;
import com.dweb.paldelight.block.SumacBlock;
import com.dweb.paldelight.world.gen.OliveTreeGrower;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PDBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"paldelight");
    public static final DeferredBlock<Block> OLIVE_LOG = BLOCKS.register("olive_log", () -> PDBlocks.log(() -> ((Block)STRIPPED_OLIVE_LOG.get()).defaultBlockState(), MapColor.COLOR_BROWN, MapColor.COLOR_BROWN));
    public static final DeferredBlock<Block> STRIPPED_OLIVE_LOG = BLOCKS.register("stripped_olive_log", () -> PDBlocks.log(MapColor.COLOR_BROWN, MapColor.COLOR_BROWN));
    public static final DeferredBlock<Block> OLIVE_WOOD = BLOCKS.register("olive_wood", () -> PDBlocks.log(() -> ((Block)STRIPPED_OLIVE_WOOD.get()).defaultBlockState(), MapColor.COLOR_BROWN, MapColor.COLOR_BROWN));
    public static final DeferredBlock<Block> STRIPPED_OLIVE_WOOD = BLOCKS.register("stripped_olive_wood", () -> PDBlocks.log(MapColor.COLOR_BROWN, MapColor.COLOR_BROWN));
    public static final DeferredBlock<Block> OLIVE_PLANKS = BLOCKS.register("olive_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final DeferredBlock<Block> OLIVE_STAIRS = BLOCKS.register("olive_stairs", () -> new StairBlock(((Block)OLIVE_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OLIVE_PLANKS.get()))));
    public static final DeferredBlock<Block> OLIVE_SLAB = BLOCKS.register("olive_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OLIVE_PLANKS.get()))));
    public static final DeferredBlock<Block> ORNATE_OLIVE_PLANKS = BLOCKS.register("ornate_olive_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)OLIVE_PLANKS.get()))));
    public static final DeferredBlock<Block> OLIVE_LEAVES = BLOCKS.register("olive_leaves", () -> new OliveLeaves(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isSuffocating(PDBlocks::never).isViewBlocking(PDBlocks::never).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor(PDBlocks::never)));
    public static final DeferredBlock<Block> OLIVE_SAPLING = BLOCKS.register("olive_sapling", () -> new SaplingBlock(OliveTreeGrower.OLIVE_TREE_GROWER, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SUMAC = BLOCKS.register("sumac", () -> new SumacBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).sound(SoundType.GRASS).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY).randomTicks()));
    public static final BooleanProperty FRUITING = BooleanProperty.create((String)"fruiting");

    private static PDLogBlock log(Supplier<BlockState> strippedVariant, MapColor topMapColor, MapColor sideMapColor) {
        return new PDLogBlock(BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topMapColor : sideMapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava(), strippedVariant);
    }

    private static RotatedPillarBlock log(MapColor topMapColor, MapColor sideMapColor) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topMapColor : sideMapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    }

    private static boolean never(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }
}

