/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.data;

import com.dweb.paldelight.PalDelight;
import com.dweb.paldelight.block.OliveLeaves;
import com.dweb.paldelight.block.PDBlocks;
import com.dweb.paldelight.item.PDItems;
import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class PDBlockStateProvider
extends BlockStateProvider {
    public PDBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "paldelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.log(PDBlocks.OLIVE_LOG);
        this.log(PDBlocks.STRIPPED_OLIVE_LOG);
        this.wood(PDBlocks.OLIVE_WOOD, PDBlocks.OLIVE_LOG);
        this.wood(PDBlocks.STRIPPED_OLIVE_WOOD, PDBlocks.STRIPPED_OLIVE_LOG);
        this.simpleBlockWithItem((Block)PDBlocks.OLIVE_PLANKS.get());
        this.stairsWithItem((Block)PDBlocks.OLIVE_STAIRS.get(), "olive", PDBlockStateProvider.textureLocation("olive_planks"));
        this.slabWithItem((Block)PDBlocks.OLIVE_SLAB.get(), "olive", "olive_planks");
        this.simpleBlockWithItem((Block)PDBlocks.ORNATE_OLIVE_PLANKS.get());
        ModelFile nonFruiting = this.cubeAll("olive_leaves");
        ModelFile fruiting = this.cubeAll("olive_leaves_fruiting");
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)PDBlocks.OLIVE_LEAVES.get()).partialState().with((Property)OliveLeaves.FRUITING, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(fruiting).addModel()).partialState().with((Property)OliveLeaves.FRUITING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(nonFruiting).addModel();
        this.simpleBlockItem((Block)PDBlocks.OLIVE_LEAVES.get(), nonFruiting);
        this.flatItem(PDItems.OLIVE_SAPLING, PDBlockStateProvider::textureLocation);
        this.flatItem(PDItems.SUMAC, id -> PDBlockStateProvider.textureLocation(id.withSuffix("_top_fruiting")));
    }

    public ModelFile cubeAll(String name) {
        return this.models().cubeAll(name, PDBlockStateProvider.textureLocation(name));
    }

    public void flatItem(DeferredItem<? extends BlockItem> item, Function<ResourceLocation, ResourceLocation> textureProvider) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", textureProvider.apply(item.getId()));
    }

    public void log(DeferredBlock<Block> log) {
        this.rotatedPillarPlusItem(log, blockId -> this.models().cubeColumn(blockId.getPath(), PDBlockStateProvider.textureLocation(blockId), PDBlockStateProvider.textureLocation(blockId).withSuffix("_top")));
    }

    public void wood(DeferredBlock<Block> wood, DeferredBlock<Block> log) {
        this.rotatedPillarPlusItem(wood, blockId -> this.models().cubeColumn(blockId.getPath(), PDBlockStateProvider.textureLocation(log.getId()), PDBlockStateProvider.textureLocation(log.getId())));
    }

    public void simpleBlockWithItem(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
        this.simpleBlockItem(block, this.cubeAll(block));
    }

    public void simpleBlock(DeferredBlock<? extends Block> block, Function<ResourceLocation, ModelFile> modelProvider) {
        this.simpleBlock((Block)block.get(), modelProvider.apply(block.getId()));
    }

    void stairsWithItem(Block block, String baseName, ResourceLocation texture) {
        ModelBuilder stairs = this.models().stairs(baseName + "_stairs", texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner_stairs", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer_stairs", texture, texture, texture);
        this.stairsBlock((StairBlock)block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem(block, (ModelFile)stairs);
    }

    void slabWithItem(Block block, String baseName, String textureName) {
        ResourceLocation texture = PDBlockStateProvider.textureLocation(textureName);
        ModelBuilder slabBottom = this.models().slab(baseName + "_slab", texture, texture, texture);
        ModelBuilder slabTop = this.models().slabTop(baseName + "_slab_top", texture, texture, texture);
        ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(PalDelight.id(textureName));
        this.slabBlock((SlabBlock)block, (ModelFile)slabBottom, (ModelFile)slabTop, (ModelFile)doubleSlab);
        this.simpleBlockItem(block, (ModelFile)slabBottom);
    }

    @NotNull
    private static ResourceLocation textureLocation(ResourceLocation blockId) {
        return blockId.withPrefix("block/");
    }

    @NotNull
    private static ResourceLocation textureLocation(String blockName) {
        return PalDelight.id("block/" + blockName);
    }

    public void rotatedPillarPlusItem(DeferredBlock<Block> block, Function<ResourceLocation, ModelFile> modelProvider) {
        ModelFile model = modelProvider.apply(block.getId());
        this.axisBlock((RotatedPillarBlock)block.get(), model, model);
        this.simpleBlockItem((Block)block.get(), model);
    }
}

