/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.data;

import com.dweb.paldelight.block.PDBlocks;
import com.dweb.paldelight.world.gen.PDConfiguredFeatures;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.GiantTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public final class PDConfiguredFeatureProvider {
    public static final BeehiveDecorator BEEHIVE_DECORATOR = new BeehiveDecorator(0.02f);
    public static final int OLIVE_TREE_TRIES = 2;

    public static void register(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(PDConfiguredFeatures.OLIVE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createStraightBlobOliveTree(false, 4, 2, 0).build()));
        context.register(PDConfiguredFeatures.OLIVE_TREE_BEES, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createStraightBlobOliveTree(true, 4, 2, 0).build()));
        context.register(PDConfiguredFeatures.FANCY_OLIVE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createFancyOliveTree(false, 5, 2, 2).build()));
        context.register(PDConfiguredFeatures.FANCY_OLIVE_TREE_BEES, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createFancyOliveTree(true, 5, 2, 2).build()));
        context.register(PDConfiguredFeatures.ANCIENT_OLIVE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createAncientOliveTree(false, 5, 3, 3).build()));
        context.register(PDConfiguredFeatures.ANCIENT_OLIVE_TREE_BEES, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)PDConfiguredFeatureProvider.createAncientOliveTree(true, 5, 3, 3).build()));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobOliveTree(boolean bees, int baseHeight, int heightRandA, int heightRandB) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ROOTED_DIRT)).decorators(bees ? List.of(BEEHIVE_DECORATOR) : List.of()).forceDirt().ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyOliveTree(boolean bees, int baseHeight, int heightRandA, int heightRandB) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2, OptionalInt.of(4))).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ROOTED_DIRT)).decorators(bees ? List.of(BEEHIVE_DECORATOR) : List.of()).forceDirt().ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createAncientOliveTree(boolean bees, int baseHeight, int heightRandA, int heightRandB) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LOG.get())), (TrunkPlacer)new GiantTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)PDBlocks.OLIVE_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)3), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2, OptionalInt.of(4))).dirt((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ROOTED_DIRT)).decorators(bees ? List.of(BEEHIVE_DECORATOR) : List.of()).forceDirt();
    }
}

