/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.data;

import com.dweb.paldelight.data.PDBlockStateProvider;
import com.dweb.paldelight.data.PDConfiguredFeatureProvider;
import com.dweb.paldelight.data.PDItemModelProvider;
import com.dweb.paldelight.data.PDLanguageProvider;
import com.dweb.paldelight.data.loot.PDLootTableProvider;
import com.dweb.paldelight.data.tag.PDBlockTagProvider;
import com.dweb.paldelight.data.tag.PDItemTagProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="paldelight", bus=EventBusSubscriber.Bus.MOD)
public class PDDataGenerators {
    @SubscribeEvent
    public static void gatherDataEvent(GatherDataEvent event) {
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        DatapackBuiltinEntriesProvider builtinEntries = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), PDDataGenerators.registrySetBuilder(), Set.of("paldelight")));
        CompletableFuture lookupProvider = builtinEntries.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)PDLootTableProvider.providers(packOutput, lookupProvider));
        PDBlockTagProvider blockTags = (PDBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new PDBlockTagProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new PDItemTagProvider(packOutput, lookupProvider, blockTags.contentsGetter(), fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new PDBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new PDItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new PDLanguageProvider(packOutput));
    }

    private static RegistrySetBuilder registrySetBuilder() {
        return new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, PDConfiguredFeatureProvider::register);
    }
}

