/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.data.loot;

import com.dweb.paldelight.block.OliveLeaves;
import com.dweb.paldelight.block.PDBlocks;
import com.dweb.paldelight.item.PDItems;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class PDBlockLootTables
extends BlockLootSubProvider {
    private static final float[] OLIVE_LEAVES_RESOURCES_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    PDBlockLootTables(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.dropSelf((Block)PDBlocks.OLIVE_LOG.get());
        this.dropSelf((Block)PDBlocks.STRIPPED_OLIVE_LOG.get());
        this.dropSelf((Block)PDBlocks.OLIVE_WOOD.get());
        this.dropSelf((Block)PDBlocks.STRIPPED_OLIVE_WOOD.get());
        this.dropSelf((Block)PDBlocks.OLIVE_PLANKS.get());
        this.dropSelf((Block)PDBlocks.OLIVE_STAIRS.get());
        this.add((Block)PDBlocks.OLIVE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)PDBlocks.ORNATE_OLIVE_PLANKS.get());
        this.add((Block)PDBlocks.OLIVE_LEAVES.get(), block -> this.createOliveLeavesDrops((Block)block, (Block)PDBlocks.OLIVE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)PDBlocks.OLIVE_SAPLING.get());
        this.dropWhenSilkTouch((Block)PDBlocks.SUMAC.get());
    }

    protected LootTable.Builder createOliveLeavesDrops(Block leavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fortuneHolder = registrylookup.getOrThrow(Enchantments.FORTUNE);
        LootItemBlockStatePropertyCondition.Builder isFruitingBuilder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)PDBlocks.OLIVE_LEAVES.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OliveLeaves.FRUITING, true));
        return this.createSilkTouchOrShearsDispatchTable(leavesBlock, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)saplingBlock))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortuneHolder, (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS.or(this.hasSilkTouch()).invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortuneHolder, (float[])OLIVE_LEAVES_RESOURCES_CHANCES)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)isFruitingBuilder).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)PDItems.OLIVE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortuneHolder, (float[])OLIVE_LEAVES_RESOURCES_CHANCES))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals("paldelight")).map(Map.Entry::getValue).toList();
    }
}

