/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.data.tag;

import com.dweb.paldelight.PalDelight;
import com.dweb.paldelight.data.tag.PDTags;
import com.dweb.paldelight.item.PDItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class PDItemTagProvider
extends ItemTagsProvider {
    public static final TagKey<Item> OLIVE_FORGE = PDItemTagProvider.forgeTag("vegetables/olive");
    public static final TagKey<Item> OLIVE_C = PDItemTagProvider.cTag("olive");
    public static final TagKey<Item> OLIVE_OIL = PDItemTagProvider.cTag("olive_oil");
    public static final TagKey<Item> COOKING_OIL = PDItemTagProvider.cTag("cooking_oil");
    public static final TagKey<Item> RAW_MUTTON = PDItemTagProvider.cTag("foods/raw_mutton");
    public static final TagKey<Item> FATAYER_FILLING = PDItemTagProvider.palTag("fatayer_filling");

    public PDItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "paldelight", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copy(PDTags.Blocks.OLIVE_LOGS, PDTags.Items.OLIVE_LOGS);
        this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
        this.tag(OLIVE_FORGE).add((Object)((Item)PDItems.OLIVE.get())).replace(false);
        this.tag(OLIVE_C).add((Object)((Item)PDItems.OLIVE.get())).replace(false);
        this.tag(OLIVE_OIL).add((Object)((Item)PDItems.OLIVE_OIL.get())).replace(false);
        this.tag(COOKING_OIL).add((Object)((Item)PDItems.OLIVE_OIL.get())).replace().replace(false);
        this.tag(RAW_MUTTON).add((Object)Items.MUTTON).replace(false);
        this.tag(FATAYER_FILLING).addTag(RAW_MUTTON).addOptionalTag(PDItemTagProvider.cPath("rawmutton")).addOptionalTag(PDItemTagProvider.cPath("cheese/cheese")).addOptionalTag(PDItemTagProvider.cPath("cheese")).addOptionalTag(PDItemTagProvider.cPath("vegetables/spinach")).addOptionalTag(PDItemTagProvider.cPath("crops/spinach"));
    }

    private static ResourceLocation forgePath(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name);
    }

    private static TagKey<Item> forgeTag(String name) {
        return ItemTags.create((ResourceLocation)PDItemTagProvider.forgePath(name));
    }

    private static ResourceLocation cPath(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)name);
    }

    private static TagKey<Item> cTag(String name) {
        return ItemTags.create((ResourceLocation)PDItemTagProvider.cPath(name));
    }

    private static TagKey<Item> palTag(String name) {
        return ItemTags.create((ResourceLocation)PalDelight.id(name));
    }
}

