/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class BottledDrinkItem
extends Item {
    private final SoundEvent drinkSound;

    public BottledDrinkItem(Item.Properties properties) {
        super(properties);
        this.drinkSound = SoundEvents.GENERIC_DRINK;
    }

    public BottledDrinkItem(SoundEvent drinkSound, Item.Properties properties) {
        super(properties);
        this.drinkSound = drinkSound;
    }

    public SoundEvent getDrinkingSound() {
        return this.drinkSound;
    }

    public SoundEvent getEatingSound() {
        return this.drinkSound;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.getFoodProperties(entity) != null) {
            super.finishUsingItem(stack, level, entity);
        } else if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        if (stack.isEmpty()) {
            return containerStack;
        }
        if (entity instanceof Player && !(player = (Player)entity).isCreative() && !player.getInventory().add(containerStack)) {
            player.drop(containerStack, false);
        }
        return stack;
    }
}

