/*
 * Decompiled with CFR 0.152.
 */
package com.dweb.paldelight.item;

import com.dweb.paldelight.block.PDBlocks;
import com.dweb.paldelight.item.BottledDrinkItem;
import com.dweb.paldelight.item.SumacBerriesItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class PDItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"paldelight");
    private static final float DEFAULT_EAT_SECONDS = 1.6f;
    public static final DeferredItem<Item> OLIVE = ITEMS.register("olive", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().fast().nutrition(1).saturationModifier(0.2f).build())));
    public static final DeferredItem<Item> OLIVE_OIL = ITEMS.register("olive_oil", () -> new BottledDrinkItem(SoundEvents.HONEY_DRINK, new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.5f).build())));
    public static final DeferredItem<Item> SUMAC_BERRIES = ITEMS.register("sumac_berries", () -> new SumacBerriesItem(new Item.Properties()));
    public static final DeferredItem<Item> ROSE_WATER = ITEMS.register("rose_water", () -> new BottledDrinkItem(new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).build())));
    public static final DeferredItem<Item> FATAYER = ITEMS.register("fatayer", () -> new Item(new Item.Properties().food(PDItems.eatProperties(8, 0.8f, 1.2f, (Holder<MobEffect>)ModEffects.COMFORT, 1200))));
    public static final DeferredItem<Item> KNAFEH = ITEMS.register("knafeh", () -> new Item(new Item.Properties().food(PDItems.eatProperties(7, 0.6f, (Holder<MobEffect>)ModEffects.COMFORT, 1200))));
    public static final DeferredItem<Item> MAQLUBA = ITEMS.register("maqluba", () -> new Item(new Item.Properties().craftRemainder(Items.BOWL).food(PDItems.eatProperties(14, 0.8f, (Holder<MobEffect>)ModEffects.NOURISHMENT, 6000))));
    public static final DeferredItem<BlockItem> OLIVE_LOG = PDItems.blockItem(PDBlocks.OLIVE_LOG);
    public static final DeferredItem<BlockItem> STRIPPED_OLIVE_LOG = PDItems.blockItem(PDBlocks.STRIPPED_OLIVE_LOG);
    public static final DeferredItem<BlockItem> OLIVE_WOOD = PDItems.blockItem(PDBlocks.OLIVE_WOOD);
    public static final DeferredItem<BlockItem> STRIPPED_OLIVE_WOOD = PDItems.blockItem(PDBlocks.STRIPPED_OLIVE_WOOD);
    public static final DeferredItem<BlockItem> OLIVE_PLANKS = PDItems.blockItem(PDBlocks.OLIVE_PLANKS);
    public static final DeferredItem<BlockItem> OLIVE_STAIRS = PDItems.blockItem(PDBlocks.OLIVE_STAIRS);
    public static final DeferredItem<BlockItem> OLIVE_SLAB = PDItems.blockItem(PDBlocks.OLIVE_SLAB);
    public static final DeferredItem<BlockItem> ORNATE_OLIVE_PLANKS = PDItems.blockItem(PDBlocks.ORNATE_OLIVE_PLANKS);
    public static final DeferredItem<BlockItem> OLIVE_LEAVES = PDItems.blockItem(PDBlocks.OLIVE_LEAVES);
    public static final DeferredItem<BlockItem> OLIVE_SAPLING = PDItems.blockItem(PDBlocks.OLIVE_SAPLING);
    public static final DeferredItem<BlockItem> SUMAC = PDItems.blockItem(PDBlocks.SUMAC);

    public static DeferredItem<BlockItem> blockItem(DeferredBlock<? extends Block> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static FoodProperties eatProperties(int nutrition, float saturationMod, Holder<MobEffect> effectHolder, int effectDuration) {
        return PDItems.eatProperties(nutrition, saturationMod, 1.6f, effectHolder, effectDuration);
    }

    public static FoodProperties eatProperties(int nutrition, float saturationMod, float eatDuration, Holder<MobEffect> effectHolder, int effectDuration) {
        List farmersEffects;
        MobEffect effect = (MobEffect)effectHolder.value();
        if (!ModList.get().isLoaded("farmersdelight") && (farmersEffects = ((Registry)ModEffects.EFFECTS.getRegistry().get()).stream().toList()).contains(effect)) {
            effect = null;
        }
        ArrayList<FoodProperties.PossibleEffect> possibleEffects = new ArrayList<FoodProperties.PossibleEffect>();
        if (effect != null) {
            possibleEffects.add(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(effectHolder, effectDuration, 0, false, false), 1.0f));
        }
        float saturation = FoodConstants.saturationByModifier((int)nutrition, (float)saturationMod);
        return new FoodProperties(nutrition, saturation, false, eatDuration, Optional.empty(), possibleEffects);
    }
}

