/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.nonliving.vanilla;

import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.entities.nonliving.vanilla.TridentEntityJS;
import net.liopyu.entityjs.item.TridentItemBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public class TridentJSBuilder
extends BaseEntityBuilder<TridentEntityJS> {
    public transient Consumer<ContextUtils.ProjectileEntityHitContext> onHitEntity;
    public transient Consumer<ContextUtils.ProjectileBlockHitContext> onHitBlock;
    public transient Function<Entity, Object> canHitEntity;
    public transient Consumer<ContextUtils.CollidingProjectileEntityContext> onEntityCollision;
    public transient TridentItemBuilder item;
    public transient boolean noItem;
    public transient SoundEvent defaultHitGroundSoundEvent;
    public transient SoundEvent defaultTridentHitSound;
    public transient SoundEvent thunderHitSound;
    public transient float thunderHitVolume;
    public transient Function<TridentEntityJS, Object> isChanneling;
    public transient DamageSource damageSource;
    public transient float attackDamage;
    public transient boolean alwaysThunder;
    public boolean canShootFromDispenser = true;

    public TridentJSBuilder(ResourceLocation i) {
        super(i);
        this.item = (TridentItemBuilder)new TridentItemBuilder(this.id, this).canThrow(false).texture(i.getNamespace() + ":item/" + i.getPath());
        this.defaultHitGroundSoundEvent = SoundEvents.TRIDENT_HIT_GROUND;
        this.thunderHitSound = (SoundEvent)SoundEvents.TRIDENT_THUNDER.value();
        this.defaultTridentHitSound = SoundEvents.TRIDENT_HIT;
        this.alwaysThunder = false;
        this.thunderHitVolume = 5.0f;
        this.attackDamage = 8.0f;
    }

    @Info(value="Sets whether or not the projectile can be shot from dispenser blocks, if noItem is set to true this will not register DispenserBehavior.")
    public TridentJSBuilder setCanShootFromDispenser(boolean canShootFromDispenser) {
        this.canShootFromDispenser = canShootFromDispenser;
        return this;
    }

    public TridentJSBuilder setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    @Info(value="@param alwaysThunder A boolean value determining if the trident always causes thunder on hit, regardless of weather.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setAlwaysThunder(true);\n    ```\n")
    public TridentJSBuilder setAlwaysThunder(boolean alwaysThunder) {
        this.alwaysThunder = alwaysThunder;
        return this;
    }

    @Info(value="@param damageSource The source of damage caused by the trident.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setDamageSource(DamageSource.thrownProjectile);\n    ```\n")
    public TridentJSBuilder setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        return this;
    }

    @Info(value="@param defaultTridentHitSound The sound event to be played when the trident hits an entity by default.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setDefaultTridentHitSound(SoundEvents.TRIDENT_HIT);\n    ```\n")
    public TridentJSBuilder setDefaultTridentHitSound(SoundEvent defaultTridentHitSound) {
        this.defaultTridentHitSound = defaultTridentHitSound;
        return this;
    }

    @Info(value="@param thunderHitSound The sound event to be played when the trident hits an entity during a thunderstorm.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setThunderHitSound(SoundEvents.THUNDER);\n    ```\n")
    public TridentJSBuilder setThunderHitSound(SoundEvent thunderHitSound) {
        this.thunderHitSound = thunderHitSound;
        return this;
    }

    @Info(value="@param isChanneling A function that determines whether the trident entity has the channeling enchantment.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setIsChanneling(tridentEntity => {\n        return false;\n    });\n    ```\n")
    public TridentJSBuilder setIsChanneling(Function<TridentEntityJS, Object> isChanneling) {
        this.isChanneling = isChanneling;
        return this;
    }

    @Info(value="@param defaultHitGroundSoundEvent The sound event to be played when the trident hits the ground by default.\n\n    Example usage:\n    ```javascript\n    tridentBuilder.setDefaultHitGroundSoundEvent(SoundEvents.GENERIC_HIT);\n    ```\n")
    public TridentJSBuilder setDefaultHitGroundSoundEvent(SoundEvent defaultHitGroundSoundEvent) {
        this.defaultHitGroundSoundEvent = defaultHitGroundSoundEvent;
        return this;
    }

    @Info(value="Indicates that no projectile item should be created for this entity type")
    public TridentJSBuilder noItem() {
        this.noItem = true;
        return this;
    }

    @Override
    public EntityType.EntityFactory<TridentEntityJS> factory() {
        return (type, level) -> new TridentEntityJS(this, (EntityType<? extends TridentEntityJS>)type, level);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return null;
    }

    @Info(value="Creates the arrow item for this entity type")
    public TridentJSBuilder item(Consumer<TridentItemBuilder> item) {
        this.item = new TridentItemBuilder(this.id, this);
        item.accept(this.item);
        return this;
    }

    public void createAdditionalObjects(AdditionalObjectRegistry registry) {
        if (!this.noItem) {
            registry.add(Registries.ITEM, (BuilderBase)this.item);
        }
    }

    @Info(value="Sets a callback function to be executed when the projectile\ncollides with an entity.\n\nExample usage:\n```javascript\narrowEntityBuilder.onEntityCollision(context => {\n    const { entity, target } = context\n    console.log(entity)\n});\n```\n")
    public TridentJSBuilder onEntityCollision(Consumer<ContextUtils.CollidingProjectileEntityContext> consumer) {
        this.onEntityCollision = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits an entity.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileEntityHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific entity.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitEntity(context -> {\n    // Custom logic to handle the projectile hitting an entity.\n    // Access information about the entity and projectile using the provided context.\n});\n```\n")
    public TridentJSBuilder onHitEntity(Consumer<ContextUtils.ProjectileEntityHitContext> consumer) {
        this.onHitEntity = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits a block.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileBlockHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific block.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitBlock(context -> {\n    // Custom logic to handle the projectile hitting a block.\n    // Access information about the block and projectile using the provided context.\n});\n```\n")
    public TridentJSBuilder onHitBlock(Consumer<ContextUtils.ProjectileBlockHitContext> consumer) {
        this.onHitBlock = consumer;
        return this;
    }

    @Info(value="Sets a function to determine if the projectile entity can hit a specific entity.\n\n@param canHitEntity The predicate to check if the arrow can hit the entity.\n\nExample usage:\n```javascript\nprojectileEntityBuilder.canHitEntity(entity -> {\n    // Custom logic to determine if the projectile can hit the specified entity\n    // Return true if the arrow can hit, false otherwise.\n});\n```\n")
    public TridentJSBuilder canHitEntity(Function<Entity, Object> function) {
        this.canHitEntity = function;
        return this;
    }
}

