/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.client.living.model.EntityModelJS;
import net.liopyu.entityjs.client.living.model.GeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class KubeJSEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    private final BaseLivingEntityBuilder<T> builder;

    public KubeJSEntityRenderer(EntityRendererProvider.Context renderManager, BaseLivingEntityBuilder<T> builder) {
        super(renderManager, new EntityModelJS<T>(builder));
        Object layerPart;
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (GeoLayerJSBuilder<T> geoBuilder : builder.layerList) {
            layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
        for (GeoLayerJSBuilder<T> geoBuilder : builder.glowingLayerList) {
            layerPart = geoBuilder.buildGlowing(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
    }

    public String entityName() {
        return ((LivingEntity)this.animatable).getType().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContext context = new ContextUtils.ScaleModelRenderContext(widthScale, heightScale, poseStack, (LivingEntity)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply(entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        try {
            if (this.builder.renderTypeFunction != null) {
                return this.builder.renderTypeFunction.apply(animatable);
            }
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderTypeFunction.", e);
        }
        return switch (((IAnimatableJS)animatable).getBuilder().renderType) {
            default -> throw new MatchException(null, null);
            case BaseLivingEntityBuilder.RenderType.SOLID -> RenderType.entitySolid((ResourceLocation)texture);
            case BaseLivingEntityBuilder.RenderType.CUTOUT -> RenderType.entityCutout((ResourceLocation)texture);
            case BaseLivingEntityBuilder.RenderType.TRANSLUCENT -> RenderType.entityTranslucent((ResourceLocation)texture);
        };
    }

    public void render(T animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.RenderContext<T> context = new ContextUtils.RenderContext<T>(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.render(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.render(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (this.isShaking((Entity)animatable)) {
            rotationYaw += (float)(Math.cos((double)((LivingEntity)animatable).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (!animatable.hasPose(Pose.SLEEPING)) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if (animatable instanceof LivingEntity) {
            T livingEntity = animatable;
            if (((LivingEntity)livingEntity).deathTime > 0 && this.builder.defaultDeathPose.booleanValue()) {
                float deathRotation = ((float)((LivingEntity)livingEntity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)animatable)));
            } else if (livingEntity.isAutoSpinAttack()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)livingEntity).tickCount + partialTick) * -75.0f));
            } else if (animatable.hasPose(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.getBedOrientation();
                poseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle((Direction)bedOrientation) : rotationYaw));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation((Entity)animatable)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (LivingEntityRenderer.isEntityUpsideDown(livingEntity)) {
                poseStack.translate(0.0f, (animatable.getBbHeight() + 0.1f) / nativeScale, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }
}

