/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.entityjs;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IArrowEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArrowEntityJS
extends AbstractArrow
implements IArrowEntityJS {
    public final ArrowEntityJSBuilder builder;
    private EntityJSHelperClass.EntityMovementTracker movementTracker;
    private boolean isMoving;
    private int knockBack;

    public ArrowEntityJS(ArrowEntityJSBuilder builder, EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.setBaseDamage(builder.setBaseDamage);
        this.movementTracker = new EntityJSHelperClass.EntityMovementTracker();
        this.knockBack = builder.setKnockback;
    }

    public ArrowEntityJS(ArrowEntityJSBuilder builder, Level level, LivingEntity shooter, ItemStack stack, @Nullable ItemStack weapon) {
        super((EntityType)builder.get(), shooter, level, stack, weapon);
        this.builder = builder;
        this.setBaseDamage(builder.setBaseDamage);
        this.movementTracker = new EntityJSHelperClass.EntityMovementTracker();
        this.knockBack = builder.setKnockback;
    }

    public ArrowEntityJS(Level level, ArrowEntityJSBuilder builder) {
        super((EntityType)builder.get(), level);
        this.builder = builder;
        this.setBaseDamage(builder.setBaseDamage);
        this.movementTracker = new EntityJSHelperClass.EntityMovementTracker();
        this.knockBack = builder.setKnockback;
    }

    public ArrowEntityBuilder<?> getArrowBuilder() {
        return this.builder;
    }

    @Override
    @Deprecated
    public void setPickUpItem(ItemStack stack) {
        super.setPickupItemStack(stack);
    }

    public void setPickupItemStack(ItemStack p_331486_) {
        super.setPickupItemStack(p_331486_);
    }

    public ItemStack getPickupItem() {
        return super.getPickupItem();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public String entityName() {
        return this.getType().toString();
    }

    public boolean isPushable() {
        return true;
    }

    public void push(Entity pEntity) {
        if (this.builder.onEntityCollision != null) {
            ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext((Entity)this, pEntity);
            EntityJSHelperClass.consumerCallback(this.builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEntityCollision.");
        }
        if (this.builder.isPushable) {
            super.push(pEntity);
        }
    }

    protected void tickDespawn() {
        if (this.builder.tickDespawn != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tickDespawn, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickDespawn.");
        } else {
            super.tickDespawn();
        }
    }

    protected void doPostHurtEffects(LivingEntity target) {
        if (this.builder.doPostHurtEffects != null) {
            ContextUtils.ArrowLivingEntityContext context = new ContextUtils.ArrowLivingEntityContext(this, target);
            EntityJSHelperClass.consumerCallback(this.builder.doPostHurtEffects, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: doPostHurtEffects.");
        } else {
            super.doPostHurtEffects(target);
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        if (this.builder != null && this.builder.defaultHitGroundSoundEvent != null) {
            return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.defaultHitGroundSoundEvent));
        }
        return super.getDefaultHitGroundSoundEvent();
    }

    protected float getWaterInertia() {
        return this.builder.setWaterInertia != null ? this.builder.setWaterInertia.floatValue() : super.getWaterInertia();
    }

    protected boolean tryPickup(Player player) {
        if (this.builder.tryPickup == null) {
            return super.tryPickup(player);
        }
        ContextUtils.ArrowPlayerContext context = new ContextUtils.ArrowPlayerContext(player, this);
        Object obj = this.builder.tryPickup.apply(context);
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value for tryPickup from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.tryPickup(player));
        return super.tryPickup(player);
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    public double setDamageFunction() {
        if (this.builder.setDamageFunction != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setDamageFunction.apply(this), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid setDamageFunction for arrow builder: " + String.valueOf(this.builder.setDamageFunction.apply(this)) + ". Must be a double. Defaulting to super method: 0");
            return 0.0;
        }
        return 0.0;
    }

    public void setBaseDamage(double pBaseDamage) {
        super.setBaseDamage(pBaseDamage + this.builder.setBaseDamage + this.setDamageFunction());
    }

    public void setKnockback(int pKnockback) {
        this.knockBack = pKnockback;
    }

    public int getKnockback() {
        return this.knockBack;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((Entity)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        return super.hurt(pSource, pAmount);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public void tick() {
        super.tick();
        this.isMoving = this.movementTracker.isMoving((Entity)this);
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.move, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: move.");
        }
    }

    public void playerTouch(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.playerTouch(player);
        }
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromLevel();
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.causeFallDamage(distance, damageMultiplier, damageSource);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder.onAddedToWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder != null && this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovePassenger, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger.");
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void onClientRemoval() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.onClientRemoval();
    }

    public void lavaHurt() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.lavaHurt();
    }

    protected void onFlap() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.onFlap();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.shouldRenderAtSqrDistance(distance));
        }
        return super.shouldRenderAtSqrDistance(distance);
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public boolean isAttackable() {
        return this.builder.isAttackable != null ? this.builder.isAttackable.booleanValue() : super.isAttackable();
    }

    protected void doKnockback(LivingEntity p_346111_, DamageSource p_346412_) {
        float f;
        Level level;
        if (this.firedFromWeapon != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.firedFromWeapon, (Entity)p_346111_, (DamageSource)p_346412_, (float)0.0f);
        } else {
            f = 0.0f;
        }
        double d0 = f;
        d0 += (double)(this.knockBack - 1);
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - p_346111_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                p_346111_.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    protected void onHitEntity(EntityHitResult p_36757_) {
        Level level;
        super.onHitEntity(p_36757_);
        Entity entity = p_36757_.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.getBaseDamage();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(entity1 != null ? entity1 : this));
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)d0));
        }
        int j = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long k = this.random.nextInt(j / 2 + 2);
            j = (int)Math.min(k + (long)j, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int i = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                this.doKnockback(livingentity, damagesource);
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)entity1).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(livingentity);
                }
                if (!this.level().isClientSide && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, (Collection)this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, Arrays.asList(entity));
                    }
                }
            }
            this.playSound(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
        if (this.builder != null && this.builder.onHitEntity != null) {
            ContextUtils.ArrowEntityHitContext context = new ContextUtils.ArrowEntityHitContext(p_36757_, this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitEntity, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitEntity.");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putDouble("damage", this.getBaseDamage());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("damage", 99)) {
            this.setBaseDamage(pCompound.getDouble("damage"));
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        this.setSoundEvent(this.getDefaultHitGroundSoundEvent());
        this.resetPiercedEntities();
        if (this.builder != null && this.builder.onHitBlock != null) {
            ContextUtils.ArrowBlockHitContext context = new ContextUtils.ArrowBlockHitContext(result, this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitBlock, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitBlock.");
        }
        super.onHitBlock(result);
    }

    protected boolean canHitEntity(Entity entity) {
        if (this.builder != null && this.builder.canHitEntity != null) {
            Object obj = this.builder.canHitEntity.apply(entity);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return super.canHitEntity(entity) && b != false;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid canHitEntity for arrow builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.canHitEntity(entity));
        }
        return super.canHitEntity(entity);
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity));
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.getBlockJumpFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor());
        return super.getBlockJumpFactor();
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply(this)) + ". Must be a float, defaulting to " + super.getBlockSpeedFactor());
        return super.getBlockSpeedFactor();
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.canAddPassenger(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity));
        return super.canAddPassenger(entity);
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping());
        }
        return super.isFlapping();
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply(this)) + ". Must be a float, defaulting to " + super.nextStep());
        }
        return super.nextStep();
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze());
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing());
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing());
        }
        return super.isCurrentlyGlowing();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations());
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth());
        }
        return super.showVehicleHealth();
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            Object obj = this.builder.canChangeDimensions.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from));
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_));
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance == null) {
            return super.getMaxFallDistance();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply(this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance());
        return super.getMaxFallDistance();
    }

    public boolean canBeCollidedWith() {
        if (this.builder.canBeCollidedWith == null) {
            return super.canBeCollidedWith();
        }
        Object obj = this.builder.canBeCollidedWith.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeCollidedWith());
        return super.canBeCollidedWith();
    }
}

