/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.entityjs;

import java.util.Objects;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.nonliving.entityjs.PartBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;

public class PartEntityJS<T extends LivingEntity>
extends PartEntity<T> {
    public final T parentMob;
    public final String name;
    private final EntityDimensions size;
    public float width;
    public float height;
    protected final PartBuilder<T> builder;

    public PartEntityJS(T pParentMob, String pName, float pWidth, float pHeight, PartBuilder<T> builder) {
        super(pParentMob);
        this.builder = builder;
        this.size = EntityDimensions.scalable((float)pWidth, (float)pHeight);
        this.refreshDimensions();
        this.parentMob = pParentMob;
        this.name = pName;
        this.width = pWidth;
        this.height = pHeight;
    }

    public String entityName() {
        return this.name;
    }

    public boolean isPickable() {
        return this.builder.isPickable;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.parentMob.getPickResult();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return !this.isInvulnerableTo(pSource) && this.partHurt(this, pSource, pAmount);
    }

    private boolean partHurt(PartEntityJS<T> partEntity, DamageSource pSource, float pDamage) {
        if (pDamage <= 0.0f) {
            return false;
        }
        if (this.builder.onPartHurt != null) {
            ContextUtils.PartHurtContext<T> context = new ContextUtils.PartHurtContext<T>(partEntity, pSource, pDamage, (LivingEntity)this.parentMob);
            this.builder.onPartHurt.accept(context);
            return true;
        }
        this.parentMob.hurt(pSource, pDamage);
        return true;
    }

    public boolean is(Entity pEntity) {
        return this == pEntity || this.parentMob == pEntity;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        throw new UnsupportedOperationException();
    }

    public void movePart(double pX, double pY, double pZ, float pYRot, float pXRot) {
        super.moveTo(pX, pY, pZ, pYRot, pXRot);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return this.size;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.shouldRenderAtSqrDistance(distance));
        }
        return super.shouldRenderAtSqrDistance(distance);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            this.builder.lerpTo.accept(context);
        }
    }

    public T getParent() {
        return this.parentMob;
    }

    public void tick() {
        super.tick();
        if (this.builder.tick != null) {
            this.builder.tick.accept((Entity)this);
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            this.builder.move.accept(context);
        }
    }

    public void playerTouch(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            this.builder.playerTouch.accept(context);
        } else {
            super.playerTouch(player);
        }
    }

    public boolean isAttackable() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAttackable());
        }
        return super.isAttackable();
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity));
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.getBlockJumpFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply((Entity)this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply((Entity)this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor());
        return super.getBlockJumpFactor();
    }

    public boolean isPushable() {
        return this.builder.isPushable;
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply((Entity)this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply((Entity)this)) + ". Must be a float, defaulting to " + super.getBlockSpeedFactor());
        return super.getBlockSpeedFactor();
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.canAddPassenger(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity));
        return super.canAddPassenger(entity);
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping());
        }
        return super.isFlapping();
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder.onAddedToWorld != null) {
            this.builder.onAddedToWorld.accept((Entity)this);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply((Entity)this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply((Entity)this)) + ". Must be a float, defaulting to " + super.nextStep());
        }
        return super.nextStep();
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, damageMultiplier, distance, damageSource);
            this.builder.onFall.accept(context);
        }
        return super.causeFallDamage(distance, damageMultiplier, damageSource);
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder.onSprint != null) {
            this.builder.onSprint.accept((Entity)this);
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder != null && this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovePassenger, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger.");
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder.rideTick != null) {
            this.builder.rideTick.accept((Entity)this);
        }
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze());
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing());
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null) {
            Object obj = this.builder.isCurrentlyGlowing.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing());
        }
        return super.isCurrentlyGlowing();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    public void onClientRemoval() {
        if (this.builder.onClientRemoval != null) {
            this.builder.onClientRemoval.accept((Entity)this);
        }
        super.onClientRemoval();
    }

    public void lavaHurt() {
        if (this.builder.lavaHurt != null) {
            this.builder.lavaHurt.accept((Entity)this);
        }
        super.lavaHurt();
    }

    protected void onFlap() {
        if (this.builder.onFlap != null) {
            this.builder.onFlap.accept((Entity)this);
        }
        super.onFlap();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations());
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply((Entity)this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth());
        }
        return super.showVehicleHealth();
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            this.builder.thunderHit.accept(context);
        }
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            Object obj = this.builder.canChangeDimensions.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from));
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_));
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromLevel();
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance == null) {
            return super.getMaxFallDistance();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply((Entity)this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply((Entity)this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance());
        return super.getMaxFallDistance();
    }

    public boolean canBeCollidedWith() {
        if (this.builder.canBeCollidedWith == null) {
            return super.canBeCollidedWith();
        }
        Object obj = this.builder.canBeCollidedWith.apply((Entity)this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeCollidedWith());
        return super.canBeCollidedWith();
    }
}

