/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.ArrowEntityJS;
import net.liopyu.entityjs.item.ArrowItemJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ArrowItemBuilder
extends ItemBuilder {
    public final transient ArrowEntityJSBuilder parent;
    public transient boolean canBePickedUp;

    public ArrowItemBuilder(ResourceLocation i, ArrowEntityJSBuilder parent) {
        super(i);
        this.parent = parent;
        this.canBePickedUp = true;
        this.baseTexture = i.getNamespace() + ":item/" + i.getPath();
    }

    @Info(value="Sets if the arrow can be picked up")
    public ArrowItemBuilder canBePickedup(boolean canBePickedUp) {
        this.canBePickedUp = canBePickedUp;
        return this;
    }

    public Item createObject() {
        return new ArrowItemJS(this.createItemProperties(), this.parent){

            public AbstractArrow createArrow(Level pLevel, ItemStack pStack, LivingEntity pShooter, @Nullable ItemStack weapon) {
                ArrowEntityJS arrow = new ArrowEntityJS(ArrowItemBuilder.this.parent, pLevel, pShooter, pStack, weapon);
                if (ArrowItemBuilder.this.canBePickedUp) {
                    ItemStack stack = new ItemStack((ItemLike)pStack.getItem());
                    arrow.setPickUpItem(stack);
                }
                return arrow;
            }
        };
    }
}

