/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.event.KubeEvent;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.client.utils.VertexModifier;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRendererMixin {
    @Unique
    private Object entityJs$builder;
    private EntityModel model;
    @Unique
    private EntityRenderDispatcher entityRenderDispatcher = (EntityRenderDispatcher)this;

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public <E extends Entity> void render(E entity, double pX, double pY, double pZ, float pRotationYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        Object builder;
        if (entity instanceof LivingEntity) {
            return;
        }
        EntityType entityType = entity.getType();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, entity);
            Object object = eventJS.getBuilder();
            if (object instanceof ModifyEntityBuilder) {
                builder = (ModifyEntityBuilder)object;
                if (((ModifyEntityBuilder)builder).setTextureLocation == null && ((ModifyEntityBuilder)builder).setRenderType == null) {
                    return;
                }
            }
            EventHandlers.modifyEntity.post((KubeEvent)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        if ((builder = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            Object obj;
            ContextUtils.RendererModelContext context;
            ModifyEntityBuilder builder2 = (ModifyEntityBuilder)builder;
            if (builder2.setTextureLocation != null && builder2.setRenderType != null) {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: You may not set both setRenderType and setTextureLocation at the same time for entity: " + String.valueOf(entity.getType()) + ".");
                return;
            }
            if (builder2.setTextureLocation != null) {
                context = new ContextUtils.RendererModelContext(entity, this.entityRenderDispatcher.getRenderer(entity), this.model);
                try {
                    obj = builder2.setTextureLocation.apply(context);
                    Object resourcelocation = EntityJSHelperClass.convertObjectToDesired(obj, "resourcelocation");
                    if (resourcelocation != null) {
                        ResourceLocation textureLocation = (ResourceLocation)resourcelocation;
                        this.entityjs$render(this.entityRenderDispatcher, entity, pX, pY, pZ, pRotationYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight, ci, textureLocation);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setTextureLocation field from entity: " + String.valueOf(entity.getType()) + ". Value: " + String.valueOf(resourcelocation) + ". Must be a resource location");
                    }
                    return;
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setTextureLocation from entity: " + String.valueOf(entity.getType()) + ". ", e);
                }
            }
            if (builder2.setRenderType != null) {
                context = new ContextUtils.RendererModelContext(entity, this.entityRenderDispatcher.getRenderer(entity), this.model);
                try {
                    obj = builder2.setRenderType.apply(context);
                    RenderType returnValue = EntityJSHelperClass.convertToRenderType(obj, null);
                    if (returnValue != null) {
                        this.entityjs$render(this.entityRenderDispatcher, entity, pX, pY, pZ, pRotationYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight, ci, returnValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setRenderType field from entity: " + String.valueOf(entity.getType()) + ". Must return either a resource location or a RenderType. Return null for the default texture logic.");
                    }
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setRenderType from entity: " + String.valueOf(entity.getType()) + ". ", e);
                }
            }
        }
    }

    public <E extends Entity> void entityjs$render(EntityRenderDispatcher entityRenderDispatcher, E pEntity, double pX, double pY, double pZ, float pRotationYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci, Object locationOrRenderType) {
        EntityRenderer entityrenderer = entityRenderDispatcher.getRenderer(pEntity);
        try {
            double d1;
            float f;
            Vec3 vec3 = entityrenderer.getRenderOffset(pEntity, pPartialTicks);
            double d2 = pX + vec3.x();
            double d3 = pY + vec3.y();
            double d0 = pZ + vec3.z();
            pPoseStack.pushPose();
            pPoseStack.translate(d2, d3, d0);
            MultiBufferSource interceptedBuffer = pBuffer;
            if (locationOrRenderType instanceof RenderType) {
                RenderType type = (RenderType)locationOrRenderType;
                interceptedBuffer = renderType -> new VertexModifier(pBuffer.getBuffer(type));
            } else if (locationOrRenderType instanceof ResourceLocation) {
                ResourceLocation location = (ResourceLocation)locationOrRenderType;
                interceptedBuffer = renderType -> new VertexModifier(pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)location)));
            }
            entityrenderer.render(pEntity, pRotationYaw, pPartialTicks, pPoseStack, interceptedBuffer, pPackedLight);
            if (pEntity.displayFireAnimation()) {
                entityRenderDispatcher.renderFlame(pPoseStack, pBuffer, pEntity, Mth.rotationAroundAxis((Vector3f)Mth.Y_AXIS, (Quaternionf)entityRenderDispatcher.cameraOrientation, (Quaternionf)new Quaternionf()));
            }
            pPoseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
            if (((Boolean)entityRenderDispatcher.options.entityShadows().get()).booleanValue() && entityRenderDispatcher.shouldRenderShadow && entityrenderer.shadowRadius > 0.0f && !pEntity.isInvisible() && (f = (float)((1.0 - (d1 = entityRenderDispatcher.distanceToSqr(pEntity.getX(), pEntity.getY(), pEntity.getZ())) / 256.0) * (double)entityrenderer.shadowStrength)) > 0.0f) {
                EntityRenderDispatcher.renderShadow((PoseStack)pPoseStack, (MultiBufferSource)pBuffer, pEntity, (float)f, (float)pPartialTicks, (LevelReader)entityRenderDispatcher.level, (float)Math.min(entityrenderer.shadowRadius, 32.0f));
            }
            if (entityRenderDispatcher.renderHitBoxes && !pEntity.isInvisible() && !Minecraft.getInstance().showOnlyReducedInfo()) {
                EntityRenderDispatcher.renderHitbox((PoseStack)pPoseStack, (VertexConsumer)pBuffer.getBuffer(RenderType.lines()), pEntity, (float)pPartialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            pPoseStack.popPose();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being rendered");
            pEntity.fillCrashReportCategory(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.addCategory("Renderer details");
            crashreportcategory1.setDetail("Assigned renderer", (Object)entityrenderer);
            crashreportcategory1.setDetail("Location", (Object)CrashReportCategory.formatLocation((LevelHeightAccessor)entityRenderDispatcher.level, (double)pX, (double)pY, (double)pZ));
            crashreportcategory1.setDetail("Rotation", (Object)Float.valueOf(pRotationYaw));
            crashreportcategory1.setDetail("Delta", (Object)Float.valueOf(pPartialTicks));
            throw new ReportedException(crashreport);
        }
        ci.cancel();
    }
}

