/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.KubeEvent;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=0, remap=true)
public abstract class LivingEntityRendererMixin<T, M extends EntityModel<?>> {
    @Shadow
    protected M model;
    @Unique
    private Object entityJs$builder;

    private LivingEntityRenderer<?, M> getRenderer() {
        return (LivingEntityRenderer)this;
    }

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    private void onGetRenderType(LivingEntity entity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        Object builder;
        EntityType entityType = entity.getType();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, (Entity)entity);
            Object object = eventJS.getBuilder();
            if (object instanceof ModifyLivingEntityBuilder) {
                builder = (ModifyLivingEntityBuilder)object;
                if (((ModifyLivingEntityBuilder)builder).setTextureLocation == null && ((ModifyLivingEntityBuilder)builder).setRenderType == null) {
                    return;
                }
            }
            EventHandlers.modifyEntity.post((KubeEvent)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        if ((builder = this.entityJs$builder) instanceof ModifyLivingEntityBuilder) {
            Object obj;
            ContextUtils.RendererModelContext context;
            ModifyLivingEntityBuilder builder2 = (ModifyLivingEntityBuilder)builder;
            if (builder2.setTextureLocation != null && builder2.setRenderType != null) {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: You may not set both setRenderType and setTextureLocation at the same time for entity: " + String.valueOf(entity.getType()) + ".");
                return;
            }
            if (builder2.setTextureLocation != null) {
                context = new ContextUtils.RendererModelContext((Entity)entity, (EntityRenderer<?>)this.getRenderer(), (EntityModel<?>)this.model);
                try {
                    obj = builder2.setTextureLocation.apply(context);
                    Object resourcelocation = EntityJSHelperClass.convertObjectToDesired(obj, "resourcelocation");
                    if (resourcelocation != null) {
                        ResourceLocation textureLocation = (ResourceLocation)resourcelocation;
                        if (translucent) {
                            cir.setReturnValue((Object)RenderType.itemEntityTranslucentCull((ResourceLocation)textureLocation));
                            return;
                        }
                        if (bodyVisible) {
                            cir.setReturnValue((Object)this.model.renderType(textureLocation));
                            return;
                        }
                        RenderType finalValue = glowing ? RenderType.outline((ResourceLocation)textureLocation) : null;
                        cir.setReturnValue((Object)finalValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setTextureLocation field from entity: " + String.valueOf(entity.getType()) + ". Value: " + String.valueOf(resourcelocation) + ". Must be a resource location");
                    }
                    return;
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setTextureLocation from entity: " + String.valueOf(entity.getType()) + ". ", e);
                }
            }
            if (builder2.setRenderType != null) {
                context = new ContextUtils.RendererModelContext((Entity)entity, (EntityRenderer<?>)this.getRenderer(), (EntityModel<?>)this.model);
                try {
                    obj = builder2.setRenderType.apply(context);
                    RenderType returnValue = EntityJSHelperClass.convertToRenderType(obj, cir.getReturnValue());
                    if (returnValue != null) {
                        cir.setReturnValue((Object)returnValue);
                        return;
                    }
                    if (obj != null) {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value in setRenderType field from entity: " + String.valueOf(entity.getType()) + ". Must return either a resource location or a RenderType. Return null for the default texture logic.");
                    }
                }
                catch (Throwable e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in modifyEntity method setRenderType from entity: " + String.valueOf(entity.getType()) + ". ", e);
                }
            }
        }
    }
}

