/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.KubeEvent;
import net.liopyu.entityjs.builders.modification.ModifyMobBuilder;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class}, remap=true)
public class MobMixin {
    @Unique
    private Object entityJs$builder;
    @Unique
    private Object entityJs$entityObject = this;

    @Unique
    private Mob entityJs$getLivingEntity() {
        return (Mob)this.entityJs$entityObject;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().getType().toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void entityjs$onMobInit(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        EntityType entityType = this.entityJs$getLivingEntity().getType();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, (Entity)this.entityJs$getLivingEntity());
            EventHandlers.modifyEntity.post((KubeEvent)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
    }

    @Inject(method={"canTakeItem"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canTakeItem(ItemStack pItemstack, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.canTakeItem != null) {
                try {
                    ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this.entityJs$getLivingEntity(), pItemstack, this.entityJs$getLivingEntity().level());
                    Object obj = builder.canTakeItem.apply(context);
                    if (obj instanceof Boolean) {
                        Boolean b = (Boolean)obj;
                        cir.setReturnValue((Object)b);
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                    }
                }
                catch (Exception e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: canTakeItem. ", e);
                }
            }
        }
    }

    @Inject(method={"canPickUpLoot"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canPickUpLoot(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.canPickUpLoot != null) {
                try {
                    Object obj = builder.canPickUpLoot.apply(this.entityJs$getLivingEntity());
                    if (obj instanceof Boolean) {
                        Boolean b = (Boolean)obj;
                        cir.setReturnValue((Object)b);
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canPickUpLoot from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                    }
                }
                catch (Exception e) {
                    EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: canPickUpLoot. ", e);
                }
            }
        }
    }

    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void isSunBurnTick(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            try {
                if (builder.isSunBurnTick != null) {
                    Object obj = builder.isSunBurnTick.apply((LivingEntity)this.entityJs$getLivingEntity());
                    if (obj instanceof Boolean) {
                        Boolean b = (Boolean)obj;
                        cir.setReturnValue((Object)b);
                    } else {
                        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSunBurnTick from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super.");
                    }
                }
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: isSunBurnTick. ", e);
            }
        }
    }

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.controlledByFirstPassenger != null) {
                LivingEntity entity;
                if (!builder.controlledByFirstPassenger.booleanValue()) {
                    return;
                }
                Entity var2 = this.entityJs$getLivingEntity().getFirstPassenger();
                LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
                cir.setReturnValue((Object)var10000);
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void mobInteract(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.onMobInteract != null) {
                ContextUtils.MobInteractContext context = new ContextUtils.MobInteractContext((LivingEntity)this.entityJs$getLivingEntity(), pPlayer, pHand);
                EntityJSHelperClass.consumerCallback(builder.onMobInteract, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onMobInteract.");
            }
        }
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void doHurtTarget(Entity pEntity, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (this.entityJs$builder != null && builder.onHurtTarget != null) {
                ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onHurtTarget, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onHurtTarget.");
            }
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void setTarget(LivingEntity pTarget, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.onTargetChanged != null) {
                ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(pTarget, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.onTargetChanged, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onTargetChanged.");
            }
        }
    }

    @Inject(method={"ate"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void ate(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.ate != null) {
                EntityJSHelperClass.consumerCallback(builder.ate, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: ate.");
            }
        }
    }

    @Inject(method={"createNavigation"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void createNavigation(Level pLevel, CallbackInfoReturnable<PathNavigation> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (this.entityJs$builder == null || builder.createNavigation == null) {
                return;
            }
            ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (LivingEntity)this.entityJs$getLivingEntity());
            Object obj = builder.createNavigation.apply(context);
            if (obj instanceof PathNavigation) {
                PathNavigation p = (PathNavigation)obj;
                cir.setReturnValue((Object)p);
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for createNavigation from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be PathNavigation. Defaulting to super method.");
            }
        }
    }

    @Inject(method={"canBeLeashed"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canBeLeashed(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.canBeLeashed != null) {
                Object obj = builder.canBeLeashed.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"getMainArm"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getMainArm(CallbackInfoReturnable<HumanoidArm> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.mainArm != null) {
                cir.setReturnValue((Object)((HumanoidArm)builder.mainArm));
            }
        }
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getAmbientSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.setAmbientSound != null) {
                cir.setReturnValue((Object)((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)builder.setAmbientSound)));
            }
        }
    }

    @Inject(method={"canHoldItem"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canHoldItem(ItemStack pStack, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.canHoldItem != null) {
                ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(pStack, (LivingEntity)this.entityJs$getLivingEntity());
                Object obj = builder.canHoldItem.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"shouldDespawnInPeaceful"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void shouldDespawnInPeaceful(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.shouldDespawnInPeaceful == null) {
                return;
            }
            cir.setReturnValue((Object)builder.shouldDespawnInPeaceful);
        }
    }

    @Inject(method={"isPersistenceRequired"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isPersistenceRequired(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.isPersistenceRequired == null) {
                return;
            }
            cir.setReturnValue((Object)builder.isPersistenceRequired);
        }
    }

    @Inject(method={"getAttackBoundingBox"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getAttackBoundingBox(CallbackInfoReturnable<AABB> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.getAttackBoundingBox != null) {
                Object obj = EntityJSHelperClass.convertObjectToDesired(builder.getAttackBoundingBox.apply(this.entityJs$getLivingEntity()), "aabb");
                if (obj != null) {
                    cir.setReturnValue((Object)((AABB)obj));
                    return;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getAttackBoundingBox from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(builder.getAttackBoundingBox.apply(this.entityJs$getLivingEntity())) + ". Must be an AABB. Defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }

    @Inject(method={"getAmbientSoundInterval"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getAmbientSoundInterval(CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.ambientSoundInterval != null) {
                cir.setReturnValue((Object)((Integer)builder.ambientSoundInterval));
            }
        }
    }

    @Inject(method={"removeWhenFarAway"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void removeWhenFarAway(double pDistanceToClosestPlayer, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyMobBuilder) {
            ModifyMobBuilder builder = (ModifyMobBuilder)object;
            if (builder.removeWhenFarAway == null) {
                return;
            }
            ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (LivingEntity)this.entityJs$getLivingEntity());
            Object obj = builder.removeWhenFarAway.apply(context);
            if (obj instanceof Boolean) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }
}

