/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryKubeEvent;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.KubeResourceLocation;
import java.util.List;
import net.liopyu.entityjs.builders.misc.CustomEntityBuilder;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.implementation.IRegistryJS;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RegistryKubeEvent.class})
public class RegistryEventJSMixin<T>
implements IRegistryJS {
    @Final
    @Shadow
    private ResourceKey<Registry<EntityType<?>>> registryKey;
    @Final
    @Shadow
    public List<BuilderBase<? extends T>> created;

    @Shadow
    private <R> void addBuilder(BuilderBase<? extends R> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + String.valueOf(builder.registryKey.location()) + "'!");
        }
        if (DevProperties.get().logRegistryEventObjects) {
            ConsoleJS.STARTUP.info((Object)("~ " + String.valueOf(builder.registryKey.location()) + " | " + String.valueOf(builder.id)));
        }
        RegistryObjectStorage objStorage = RegistryObjectStorage.of((ResourceKey)builder.registryKey);
        if (objStorage.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + String.valueOf(builder.id) + "' in registry '" + String.valueOf(builder.registryKey.location()) + "'!");
        }
        objStorage.objects.put(builder.id, builder);
        RegistryObjectStorage.ALL_BUILDERS.add(builder);
    }

    @Override
    @Info(value="Creates a new custom entity based on an existing entity class.\nThis allows extending or modifying behavior of vanilla or modded entities dynamically.\n\nThe builder provided in the callback can be used to modify properties, goals, and behaviors.\n\nExample usage:\n```javascript\nevent.createCustom(\"wyrm\", Zombie);\n```\n")
    public CustomEntityBuilder entityJs$createCustom(KubeResourceLocation id, Class<? extends Entity> entityClass) {
        if (!Entity.class.isAssignableFrom(entityClass)) {
            EntityJSHelperClass.logErrorMessageOnce("Tried to create entity from a class that does not extend Entity. Id: " + String.valueOf(id));
            return null;
        }
        ResourceLocation rl = id.wrapped();
        CustomEntityBuilder b = null;
        if (LivingEntity.class.isAssignableFrom(entityClass)) {
            b = new CustomEntityBuilder(rl, entityClass);
        }
        if (b == null) {
            EntityJSHelperClass.logErrorMessageOnce("CustomEntityBuilder is null for entity id: " + String.valueOf(id));
            return null;
        }
        b.sourceLine = SourceLine.UNKNOWN;
        b.registryKey = this.registryKey;
        this.addBuilder(b);
        this.created.add(b);
        return b;
    }
}

