/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.misc.JumpControlJSBuilder;
import net.liopyu.entityjs.builders.misc.LookControlJSBuilder;
import net.liopyu.entityjs.builders.misc.MoveControlJSBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderEntityBuilder;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.ai.JumpControlJS;
import net.liopyu.entityjs.util.ai.LookControlJS;
import net.liopyu.entityjs.util.ai.MoveControlJS;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;

public interface EntityJSUtils {
    @Info(value="Helper method to get the entity's builder for the type.")
    public static <T extends BuilderBase<?>> T getEntityBuilder(EntityType<?> type) {
        for (ArrowEntityBuilder<?> arrowEntityBuilder : ArrowEntityBuilder.thisList) {
            if (arrowEntityBuilder.get() != type) continue;
            return (T)((Object)arrowEntityBuilder);
        }
        for (ProjectileEntityBuilder projectileEntityBuilder : ProjectileEntityBuilder.thisList) {
            if (projectileEntityBuilder.get() != type) continue;
            return (T)((Object)projectileEntityBuilder);
        }
        for (EyeOfEnderEntityBuilder eyeOfEnderEntityBuilder : EyeOfEnderEntityBuilder.thisList) {
            if (eyeOfEnderEntityBuilder.get() != type) continue;
            return (T)((Object)eyeOfEnderEntityBuilder);
        }
        for (CustomEntityJSBuilder customEntityJSBuilder : CustomEntityBuilder.thisList) {
            if (customEntityJSBuilder.get() != type) continue;
            return (T)((Object)customEntityJSBuilder);
        }
        for (BoatEntityBuilder boatEntityBuilder : BoatEntityBuilder.thisList) {
            if (boatEntityBuilder.get() != type) continue;
            return (T)((Object)boatEntityBuilder);
        }
        for (BaseEntityBuilder baseEntityBuilder : BaseEntityBuilder.thisList) {
            if (baseEntityBuilder.get() != type) continue;
            return (T)((Object)baseEntityBuilder);
        }
        for (BaseLivingEntityBuilder baseLivingEntityBuilder : BaseLivingEntityBuilder.thisList) {
            if (baseLivingEntityBuilder.get() != type) continue;
            return (T)((Object)baseLivingEntityBuilder);
        }
        return null;
    }

    @Info(value="Creates a custom Jump Control builder and returns it.")
    public static JumpControlJS createJumpControl(Mob pMob, Consumer<JumpControlJSBuilder> consumer) {
        JumpControlJSBuilder builder = new JumpControlJSBuilder();
        EntityJSHelperClass.consumerCallback(consumer, builder, "[EntityJS]: Error in " + String.valueOf(pMob.getType()) + "builder for field: createJumpControl.");
        return new JumpControlJS(pMob, builder);
    }

    @Info(value="Creates a custom Move Control builder and returns it.")
    public static MoveControlJS createMoveControl(Mob pMob, Consumer<MoveControlJSBuilder> consumer) {
        MoveControlJSBuilder builder = new MoveControlJSBuilder();
        EntityJSHelperClass.consumerCallback(consumer, builder, "[EntityJS]: Error in " + String.valueOf(pMob.getType()) + "builder for field: createMoveControl.");
        return new MoveControlJS(pMob, builder);
    }

    @Info(value="Creates a custom Look Control builder and returns it.")
    public static LookControlJS createLookControl(Mob pMob, Consumer<LookControlJSBuilder> consumer) {
        LookControlJSBuilder builder = new LookControlJSBuilder();
        EntityJSHelperClass.consumerCallback(consumer, builder, "[EntityJS]: Error in " + String.valueOf(pMob.getType()) + "builder for field: createLookControl.");
        return new LookControlJS(pMob, builder);
    }

    @Info(value="Ground entity path navigation")
    public static GroundPathNavigation createGroundPathNavigation(Mob pMob, Level pLevel) {
        return new GroundPathNavigation(pMob, pLevel);
    }

    @Info(value="Flying entity path navigation")
    public static FlyingPathNavigation createFlyingPathNavigation(Mob pMob, Level pLevel) {
        return new FlyingPathNavigation(pMob, pLevel);
    }

    @Info(value="Amphibious entity path navigation")
    public static AmphibiousPathNavigation createAmphibiousPathNavigation(Mob pMob, Level pLevel) {
        return new AmphibiousPathNavigation(pMob, pLevel);
    }

    @Info(value="Wall climbing entity path navigation")
    public static WallClimberNavigation createWallClimberNavigation(Mob pMob, Level pLevel) {
        return new WallClimberNavigation(pMob, pLevel);
    }

    @Info(value="Water bound entity path navigation")
    public static WaterBoundPathNavigation createWaterBoundPathNavigation(Mob pMob, Level pLevel) {
        return new WaterBoundPathNavigation(pMob, pLevel);
    }
}

