/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public enum EntitySerializerType {
    BYTE,
    INT,
    LONG,
    FLOAT,
    STRING,
    BOOLEAN,
    COMPOUND_TAG,
    UUID,
    VECTOR3,
    QUATERNION;


    public EntityDataSerializer<?> getSerializer() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EntityDataSerializers.BYTE;
            case 1 -> EntityDataSerializers.INT;
            case 2 -> EntityDataSerializers.LONG;
            case 3 -> EntityDataSerializers.FLOAT;
            case 4 -> EntityDataSerializers.STRING;
            case 5 -> EntityDataSerializers.BOOLEAN;
            case 6 -> EntityDataSerializers.COMPOUND_TAG;
            case 8 -> EntityDataSerializers.VECTOR3;
            case 9 -> EntityDataSerializers.QUATERNION;
            case 7 -> EntityDataSerializers.OPTIONAL_UUID;
        };
    }

    public static <T> T castValue(Object value, @Nullable String castHint) {
        if (value instanceof Number) {
            Number num = (Number)value;
            if (castHint != null) {
                switch (castHint.toLowerCase()) {
                    case "byte": {
                        return (T)Byte.valueOf(num.byteValue());
                    }
                    case "int": {
                        return (T)Integer.valueOf(num.intValue());
                    }
                    case "float": {
                        return (T)Float.valueOf(num.floatValue());
                    }
                    case "long": {
                        return (T)Long.valueOf(num.longValue());
                    }
                }
            }
            double d = num.doubleValue();
            if (num instanceof Float) {
                return (T)Float.valueOf(num.floatValue());
            }
            if (num instanceof Long || d % 1.0 == 0.0 && d > 2.147483647E9 && d <= 9.223372036854776E18) {
                return (T)Long.valueOf(num.longValue());
            }
            if (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9) {
                return (T)Integer.valueOf(num.intValue());
            }
            return (T)Float.valueOf(num.floatValue());
        }
        if (value instanceof UUID) {
            return (T)value;
        }
        if (value instanceof String) {
            return (T)value;
        }
        if (value instanceof Boolean) {
            return (T)value;
        }
        if (value instanceof CompoundTag) {
            return (T)value;
        }
        if (value instanceof Vector3f) {
            return (T)value;
        }
        if (value instanceof Quaternionf) {
            return (T)value;
        }
        throw new IllegalArgumentException("Unsupported value type for casting: " + String.valueOf(value.getClass()));
    }

    public static EntitySerializerType fromObject(Object value) {
        if (value instanceof Byte) {
            return BYTE;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            double d = num.doubleValue();
            if (num instanceof Float) {
                return FLOAT;
            }
            if (num instanceof Long || d % 1.0 == 0.0 && d >= -9.223372036854776E18 && d <= 9.223372036854776E18 && d > 2.147483647E9) {
                return LONG;
            }
            if (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9) {
                return INT;
            }
            return FLOAT;
        }
        if (value instanceof UUID) {
            return UUID;
        }
        if (value instanceof String) {
            return STRING;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof CompoundTag) {
            return COMPOUND_TAG;
        }
        if (value instanceof Vector3f) {
            return VECTOR3;
        }
        if (value instanceof Quaternionf) {
            return QUATERNION;
        }
        throw new IllegalArgumentException("Unsupported value type for serializer: " + String.valueOf(value.getClass()));
    }

    public static EntitySerializerType fromSerializer(EntityDataSerializer<?> serializer) {
        for (EntitySerializerType type : EntitySerializerType.values()) {
            if (type.getSerializer() != serializer) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown EntityDataSerializer: " + String.valueOf(serializer));
    }
}

