/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.recipe;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.embeddedt.modernfix.neoforge.recipe.ExtendedIngredient;

public class IngredientItemStacksSoftReference
extends SoftReference<ItemStack[]> {
    private final Ingredient ingredient;
    private static final ReferenceQueue<ItemStack[]> QUEUE = new ReferenceQueue();
    private static final Thread DISCARD_THREAD = new Thread(IngredientItemStacksSoftReference::clearReferences, "Ingredient reference clearing thread");

    public IngredientItemStacksSoftReference(Ingredient ingredient, ItemStack[] stacks) {
        super(stacks, QUEUE);
        this.ingredient = ingredient;
    }

    private static void clearReferences() {
        while (true) {
            Reference<ItemStack[]> ref;
            try {
                ref = QUEUE.remove();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!(ref instanceof IngredientItemStacksSoftReference)) continue;
            IngredientItemStacksSoftReference ingRef = (IngredientItemStacksSoftReference)ref;
            Ingredient ingredient = ingRef.ingredient;
            if (!(ingredient instanceof ExtendedIngredient)) continue;
            ExtendedIngredient extIng = (ExtendedIngredient)ingredient;
            extIng.mfix$clearReference();
        }
    }

    static {
        DISCARD_THREAD.setPriority(7);
        DISCARD_THREAD.setDaemon(true);
        DISCARD_THREAD.start();
    }
}

