/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.neoforge;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidStackImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public class SoftFluidColorsImpl {
    public static int getSpecialColor(SoftFluidStack stack, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        IClientFluidTypeExtensions prop;
        DyedItemColor dyeColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (dyeColor != null) {
            return dyeColor.rgb();
        }
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            return potionContents.getColor();
        }
        int specialColor = 0;
        Holder<Fluid> f = stack.getVanillaFluid();
        if (f != Fluids.EMPTY && (prop = IClientFluidTypeExtensions.of((Fluid)((Fluid)f.value()))) != IClientFluidTypeExtensions.DEFAULT) {
            int w = -1;
            if (stack instanceof SoftFluidStackImpl) {
                SoftFluidStackImpl ss = (SoftFluidStackImpl)stack;
                w = prop.getTintColor(ss.toForgeFluid());
            }
            if (w != -1) {
                specialColor = w;
            } else if (world != null && pos != null && (w = prop.getTintColor(((Fluid)f.value()).defaultFluidState(), world, pos)) != -1) {
                specialColor = w;
            }
        }
        return specialColor;
    }
}

