/*
 * Decompiled with CFR 0.152.
 */
package net.sabitron.minestuckserver.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sabitron.minestuckserver.init.SeasonXModItems;
import net.sabitron.minestuckserver.procedures.NilkedProcedure;

public class WagicalNilkCartonItem
extends Item {
    public WagicalNilkCartonItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).food(new FoodProperties.Builder().nutrition(-4).saturationModifier(0.6f).alwaysEdible().build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.DRINK;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        return new ItemStack((ItemLike)SeasonXModItems.WAGICAL_NILK_CARTON.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.season_x.wagical_nilk_carton.description_0"));
        list.add((Component)Component.translatable((String)"item.season_x.wagical_nilk_carton.description_1"));
        list.add((Component)Component.translatable((String)"item.season_x.wagical_nilk_carton.description_2"));
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = new ItemStack((ItemLike)SeasonXModItems.WAGICAL_NILK_CARTON.get());
        super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        NilkedProcedure.execute((LevelAccessor)world, x, y, z);
        if (itemstack.isEmpty()) {
            return retval;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().instabuild && !player.getInventory().add(retval)) {
                player.drop(retval, false);
            }
        }
        return itemstack;
    }
}

