/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.effects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.effects.StunStarModel;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class StunEffect
extends MobEffect {
    public StunEffect() {
        super(MobEffectCategory.HARMFUL, 6829738);
    }

    @EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.InteractionKeyMappingTriggered event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(EffectRegistry.STUN)) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockHighlight(RenderHighlightEvent.Block event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(EffectRegistry.STUN)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entity = event.getEntity();
            if (!entity.hasEffect(EffectRegistry.STUN) || entity.isDeadOrDying()) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(0.0f, entity.getBbHeight() + 0.15f, 0.0f);
            poseStack.scale(0.175f, 0.175f, 0.175f);
            poseStack.scale(1.0f, -1.0f, 1.0f);
            int stars = 10;
            float ticks = (float)entity.tickCount + event.getPartialTick();
            for (int i = 0; i < stars; ++i) {
                poseStack.pushPose();
                poseStack.translate(0.0f, Mth.sin((float)(ticks * 0.1f + (float)(i * 20))) * 0.2f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.cos((float)(ticks / 10.0f)) / 7.0f * 57.295776f));
                poseStack.mulPose(Axis.YP.rotationDegrees(ticks / 20.0f * 57.295776f + (float)i * (360.0f / (float)stars)));
                poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(ticks / 10.0f)) / 7.0f * 57.295776f));
                poseStack.translate(0.0f, 0.0f, 1.0f + (float)stars * 0.15f);
                StunStarModel.createBodyLayer().bakeRoot().render(event.getPoseStack(), event.getMultiBufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)StunStarModel.TEXTURE.getModel())), event.getPackedLight(), OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }
}

