/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class PickleModel<T extends LivingEntity>
extends PlayerModel<T> {
    public PickleModel(ModelPart modelPart) {
        super(modelPart, false);
    }

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 2).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 14.0f, 8.0f, false), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(2, 18).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(16, 18).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 24).addBox(3.85f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 24).addBox(-5.85f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void translateToHand(HumanoidArm handSide, PoseStack matrixStack) {
        matrixStack.translate(0.0, 0.5, 0.0);
        ModelPart arm = this.getArm(handSide);
        float f = 1.0f * (float)(handSide == HumanoidArm.RIGHT ? 1 : -1);
        arm.x += f;
        arm.y -= 1.0f;
        arm.z += 1.0f;
        arm.translateAndRotate(matrixStack);
        arm.z -= 1.0f;
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, this.riding ? -0.5 : 0.5, 0.0);
        super.renderToBuffer(matrixStack, buffer, packedLight, packedOverlay, color);
        matrixStack.popPose();
    }

    public void setupAnim(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.swimAmount > 0.0f && player.isVisuallySwimming()) {
            this.body.yRot = this.rotlerpRad(limbSwing, this.body.yRot, -0.10471976f);
        } else {
            float f1 = player.getFallFlyingTicks();
            if ((double)f1 > 0.01) {
                float inclination = Mth.clamp((float)((f1 += Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) * f1 / 100.0f), (float)0.0f, (float)1.0f);
                this.leftArm.xRot = inclination * (float)Math.PI;
                this.rightArm.xRot = inclination * (float)Math.PI;
            }
        }
    }

    public static class PickleElytra<T extends LivingEntity, M extends EntityModel<T>>
    extends ElytraLayer<T, M> {
        public PickleElytra(RenderLayerParent<T, M> renderer, EntityModelSet modelSet) {
            super(renderer, modelSet);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            matrixStack.translate(0.0, 0.625, 0.09375);
            matrixStack.scale(0.625f, 0.625f, 0.625f);
            super.render(matrixStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }

        public boolean shouldRender(ItemStack stack, T entity) {
            return !entity.isCrouching() && stack.getItem() == Items.ELYTRA;
        }
    }

    public static class PickleArmor<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
    extends HumanoidArmorLayer<T, M, A> {
        public PickleArmor(RenderLayerParent<T, M> renderer, A modelChest, ModelManager manager) {
            super(renderer, modelChest, modelChest, manager);
        }

        public void setPartVisibility(A modelIn, EquipmentSlot slotIn) {
            boolean head;
            modelIn.setAllVisible(false);
            ((HumanoidModel)modelIn).hat.visible = head = slotIn == EquipmentSlot.HEAD;
            ((HumanoidModel)modelIn).head.visible = head;
            ((HumanoidModel)modelIn).head.copyFrom(((HumanoidModel)modelIn).body);
            ((HumanoidModel)modelIn).head.y = 13.0f;
            ((HumanoidModel)modelIn).hat.copyFrom(((HumanoidModel)modelIn).head);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.isCrouching()) {
                return;
            }
            super.render(matrixStack, buffer, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

