/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlockSource;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MovingSlidyBlockEntity
extends PistonMovingBlockEntity {
    private static final ThreadLocal<Boolean> SUPPRESS_OBSERVER_HACK = ThreadLocal.withInitial(() -> false);

    public MovingSlidyBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
    }

    public MovingSlidyBlockEntity(BlockPos pos, BlockState blockState, BlockState movedState, Direction direction, boolean extending, boolean isSourcePiston) {
        super(pos, blockState, movedState, direction, extending, isSourcePiston);
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.MOVING_SLIDY_BLOCK_TILE.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MovingSlidyBlockEntity t) {
        block9: {
            BlockState movedState;
            block7: {
                BlockState blockState;
                block10: {
                    block8: {
                        if (level.isClientSide) {
                            t.spawnSlidyParticles(level, pos);
                        }
                        movedState = t.getMovedState();
                        t.lastTicked = level.getGameTime();
                        t.progressO = t.progress;
                        if (!(t.progressO >= 1.0f)) break block7;
                        if (!level.isClientSide || t.deathTicks >= 5) break block8;
                        ++t.deathTicks;
                        break block9;
                    }
                    level.removeBlockEntity(pos);
                    t.setRemoved();
                    if (!level.getBlockState(pos).is(ModRegistry.MOVING_SLIDY_BLOCK.get())) break block9;
                    blockState = Block.updateFromNeighbourShapes((BlockState)t.getMovedState(), (LevelAccessor)level, (BlockPos)pos);
                    if (!blockState.isAir()) break block10;
                    level.setBlock(pos, movedState, 84);
                    Block.updateOrDestroy((BlockState)movedState, (BlockState)blockState, (LevelAccessor)level, (BlockPos)pos, (int)3);
                    break block9;
                }
                if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                }
                SUPPRESS_OBSERVER_HACK.set(true);
                level.setBlock(pos, blockState, 83);
                SUPPRESS_OBSERVER_HACK.set(false);
                level.neighborChanged(pos, blockState.getBlock(), pos);
                if (!(level instanceof ServerLevel)) break block9;
                ServerLevel sl = (ServerLevel)level;
                blockState.tick(sl, pos, sl.random);
                break block9;
            }
            float f = (float)((double)t.progress + CommonConfigs.Building.SLIDY_BLOCK_SPEED.get());
            MovingSlidyBlockEntity.moveCollidedEntities((Level)level, (BlockPos)pos, (float)f, (PistonMovingBlockEntity)t);
            MovingSlidyBlockEntity.moveStuckEntities((Level)level, (BlockPos)pos, (float)f, (PistonMovingBlockEntity)t);
            t.progress = f;
            if (t.progress >= 1.0f) {
                t.progress = 1.0f;
                Direction direction = t.getDirection();
                if (direction.getAxis() == Direction.Axis.Y) {
                    return;
                }
                if (level.getBlockState(pos.below()).is(BlockTags.ICE)) {
                    MovingSlidyBlock.maybeMove(movedState, level, pos, direction);
                    level.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                }
                if (level.getBlockState(pos.below()).is(ModRegistry.SOAP_BLOCK.get()) && !level.isClientSide) {
                    ObjectArrayList dirs = ObjectArrayList.of((Object[])new Direction[]{direction.getClockWise(), direction.getCounterClockWise(), direction});
                    Util.shuffle((List)dirs, (RandomSource)level.random);
                    for (Direction randomDir : dirs) {
                        if (!MovingSlidyBlock.maybeMove(movedState, level, pos, randomDir)) continue;
                        level.blockEvent(pos.below(), ModRegistry.SOAP_BLOCK.get(), 0, 0);
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                        break;
                    }
                }
            }
        }
    }

    private void spawnSlidyParticles(Level level, BlockPos pos) {
        RandomSource rand = level.random;
        Direction dir = this.getDirection();
        Vector3f mul = dir.step().mul(-1.5f + this.progress);
        BlockState belowState = level.getBlockState(BlockPos.containing((Position)pos.below().getCenter().add(new Vec3(mul))));
        if (belowState.isAir()) {
            return;
        }
        BlockParticleOption opt = new BlockParticleOption(ParticleTypes.BLOCK, belowState);
        switch (dir) {
            case NORTH: {
                level.addParticle((ParticleOptions)opt, (double)((float)pos.getX() + rand.nextFloat()), (double)pos.getY(), (double)((float)pos.getZ() - this.progress + 2.0f), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.addParticle((ParticleOptions)opt, (double)((float)pos.getX() + rand.nextFloat()), (double)pos.getY(), (double)((float)pos.getZ() + this.progress - 1.0f), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.addParticle((ParticleOptions)opt, (double)((float)pos.getX() - this.progress + 2.0f), (double)pos.getY(), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                level.addParticle((ParticleOptions)opt, (double)((float)pos.getX() + this.progress - 1.0f), (double)pos.getY(), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    public void addOffset(float offset) {
        this.progressO = this.progress;
        this.progress += offset;
    }

    public static boolean shouldCancelObserverUpdateHack(BlockState neighbor) {
        Block block = neighbor.getBlock();
        if (block instanceof MovingSlidyBlockSource) {
            return true;
        }
        if (block == Blocks.AIR) {
            return SUPPRESS_OBSERVER_HACK.get();
        }
        return false;
    }
}

