/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.nicguzzo.wands.client.WandsModClient;
import net.nicguzzo.wands.client.gui.Btn;
import net.nicguzzo.wands.client.gui.Spinner;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.menues.PaletteMenu;
import net.nicguzzo.wands.utils.Colorf;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.Palette;

public class PaletteScreen
extends AbstractContainerScreen<PaletteMenu> {
    private static final ResourceLocation TEXTURE = Compat.create_resource_mc("textures/gui/container/generic_54.png");
    private Btn btn_mode;
    private Btn btn_rotate;
    private final int containerRows;
    Component mode_val;
    Component rot_on = Compat.literal("rotate: on");
    Component rot_off = Compat.literal("rotate: off");
    Spinner gradient_h;

    public PaletteScreen(PaletteMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.containerRows = 6;
        this.imageHeight = 114 + this.containerRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void init() {
        super.init();
        final ItemStack palette_itemStack = ((PaletteMenu)this.menu).palette;
        this.btn_mode = new Btn(this.width / 2 + this.imageWidth / 2, this.height / 2 - 80, 40, 20, (Component)Compat.literal("mode"), (x, y) -> {
            if (((PaletteMenu)this.menu).palette != null) {
                PaletteItem.nextMode(palette_itemStack);
                ++Palette.version;
                WandsModClient.send_palette(true, false, -1);
            }
        });
        this.btn_rotate = new Btn(this.width / 2 + this.imageWidth / 2, this.height / 2 - 60, 40, 20, (Component)Compat.literal("rotate"), (x, y) -> {
            if (((PaletteMenu)this.menu).palette != null) {
                PaletteItem.toggleRotate(palette_itemStack);
                ++Palette.version;
                WandsModClient.send_palette(false, true, -1);
            }
        });
        int v = PaletteItem.getGradientHeight(palette_itemStack);
        this.gradient_h = new Spinner(this, v, 1, 1000, this.width / 2 + this.imageWidth / 2, this.height / 2 - 122, 40, 12, (Component)Compat.literal("gradient height")){

            @Override
            public void onInc(int mx, int my, int value) {
                PaletteItem.setGradientHeight(palette_itemStack, value);
                ++Palette.version;
                WandsModClient.send_palette(false, true, value);
            }

            @Override
            public void onDec(int mx, int my, int value) {
                PaletteItem.setGradientHeight(palette_itemStack, value);
                ++Palette.version;
                WandsModClient.send_palette(false, true, value);
            }
        };
        this.gradient_h.label_side = true;
        this.gradient_h.label_col = new Colorf(1.0f, 1.0f, 1.0f, 1.0f).toInt();
        this.gradient_h.label_bg = new Colorf(0.2f, 0.2f, 0.2f, 1.0f).toInt();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        super.render(gui, mouseX, mouseY, delta);
        if (((PaletteMenu)this.menu).palette != null) {
            PaletteItem.PaletteMode mode = PaletteItem.getMode(((PaletteMenu)this.menu).palette);
            switch (mode) {
                case RANDOM: {
                    this.mode_val = PaletteItem.mode_val_random;
                    break;
                }
                case ROUND_ROBIN: {
                    this.mode_val = PaletteItem.mode_val_rr;
                    break;
                }
                case GRADIENT: {
                    this.mode_val = PaletteItem.mode_val_gradient;
                    break;
                }
                default: {
                    this.mode_val = PaletteItem.mode_val_random;
                }
            }
            CompoundTag tag = Compat.getTags(((PaletteMenu)this.menu).palette);
            boolean rot = tag.getBoolean("rotate");
            gui.drawString(this.font, rot ? this.rot_on : this.rot_off, this.width / 2 - 30, this.height / 2 - 105, 0x404040, false);
            gui.drawString(this.font, this.mode_val, this.width / 2 + 30, this.height / 2 - 105, 0x404040, false);
            this.btn_mode.render(gui, this.font, mouseX, mouseY);
            this.btn_rotate.render(gui, this.font, mouseX, mouseY);
            this.gradient_h.render(gui, this.font, mouseX, mouseY);
        }
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float f, int i, int j) {
        Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        gui.blit(TEXTURE, x, y + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
    }

    boolean is_hovering(int i, int j, int k, int l, double d, double e) {
        int m = this.leftPos;
        int n = this.topPos;
        return (d -= (double)m) >= (double)(i - 1) && d < (double)(i + k + 1) && (e -= (double)n) >= (double)(j - 1) && e < (double)(j + l + 1);
    }

    public final Slot find_slot(double d, double e) {
        for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
            if (!this.is_hovering(slot.x, slot.y, 16, 16, d, e) || !slot.isActive()) continue;
            return slot;
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.btn_mode.click((int)mouseX, (int)mouseY);
        this.btn_rotate.click((int)mouseX, (int)mouseY);
        this.gradient_h.click((int)mouseX, (int)mouseY);
        Slot slot = this.find_slot(mouseX, mouseY);
        if (slot != null) {
            switch (button) {
                case 0: {
                    if (PaletteScreen.hasShiftDown()) {
                        this.slotClicked(slot, slot.index, button, ClickType.QUICK_MOVE);
                    } else {
                        this.slotClicked(slot, slot.index, button, ClickType.PICKUP);
                    }
                    ++Palette.version;
                    break;
                }
                case 1: {
                    this.slotClicked(slot, slot.index, button, ClickType.PICKUP);
                    ++Palette.version;
                    break;
                }
                case 2: {
                    this.slotClicked(slot, slot.index, button, ClickType.CLONE);
                    ++Palette.version;
                }
            }
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Slot slot = this.find_slot(mouseX, mouseY);
        if (slot != null) {
            Minecraft client = Minecraft.getInstance();
            ItemStack itemStack = Compat.get_carried((Player)client.player, this.menu);
            if (itemStack != ItemStack.EMPTY && slot.getItem() == ItemStack.EMPTY) {
                this.slotClicked(slot, slot.index, button, ClickType.QUICK_CRAFT);
                ++Palette.version;
            }
        }
        return true;
    }
}

