/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.utils.WandUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class ItemRendererMixin {
    @Shadow
    private final Minecraft minecraft;
    @Final
    @Shadow
    private PoseStack pose;

    protected ItemRendererMixin(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    @Shadow
    protected abstract void renderItem(LivingEntity var1, Level var2, ItemStack var3, int var4, int var5, int var6, int var7);

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="TAIL")})
    public void renderItem(LivingEntity livingEntity, Level level, ItemStack itemStack, int i, int j, int k, int l, CallbackInfo cb) {
        ItemStack item_in_bag;
        if (level != null && WandUtils.is_magicbag(itemStack) && !(item_in_bag = MagicBagItem.getItem(itemStack, (HolderLookup.Provider)level.registryAccess())).isEmpty()) {
            BakedModel bakedModel = this.minecraft.getItemRenderer().getModel(itemStack, level, livingEntity, k);
            this.pose.pushPose();
            this.pose.translate((float)(i + 8), (float)(j + 8), (float)(150 + (bakedModel.isGui3d() ? l : 0) + 10));
            this.pose.scale(0.5f, 0.5f, 0.5f);
            this.pose.translate(0.0, -0.3, 0.0);
            this.pose.translate(-((float)(i + 8)), -((float)(j + 8)), -((float)(150 + (bakedModel.isGui3d() ? l : 0) + 10)));
            this.renderItem(livingEntity, level, item_in_bag, i, j + 5, k, 161);
            this.pose.popPose();
        }
    }
}

