/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.nicguzzo.wands.config.WandsConfig;
import net.nicguzzo.wands.wand.Wand;

public class BlockBuffer {
    public int max = 0;
    private int length = 0;
    public int[] buffer_x = null;
    public int[] buffer_y = null;
    public int[] buffer_z = null;
    public BlockState[] state = null;
    public Item[] item = null;
    public int min_y = 1000;
    public int max_y = -1000;
    public static List<Item> denied_item = new ArrayList<Item>();

    public BlockBuffer(int n) {
        this.max = n;
        this.buffer_x = new int[this.max];
        this.buffer_y = new int[this.max];
        this.buffer_z = new int[this.max];
        this.state = new BlockState[this.max];
        this.item = new Item[this.max];
    }

    public void reset() {
        this.length = 0;
        this.min_y = 1000;
        this.max_y = -1000;
    }

    public int get_length() {
        return this.length;
    }

    public boolean in_buffer(BlockPos p) {
        for (int i = 0; i < this.length && i < this.max; ++i) {
            if (p.getX() != this.buffer_x[i] || p.getY() != this.buffer_y[i] || p.getZ() != this.buffer_z[i]) continue;
            return true;
        }
        return false;
    }

    public void calc_min_max() {
        for (int i = 0; i < this.length && i < this.max; ++i) {
            int y = this.buffer_y[i];
            if (y < this.min_y) {
                this.min_y = y;
            }
            if (y <= this.max_y) continue;
            this.max_y = y;
        }
    }

    public BlockPos get(int i) {
        if (i < this.max) {
            return new BlockPos(this.buffer_x[i], this.buffer_y[i], this.buffer_z[i]);
        }
        return null;
    }

    public void set(int i, int x, int y, int z) {
        if (i < this.max) {
            this.buffer_x[i] = x;
            this.buffer_y[i] = y;
            this.buffer_z[i] = z;
        }
    }

    public void add(int x, int y, int z, BlockState s, Item i) {
        if (this.length < this.max) {
            this.buffer_x[this.length] = x;
            this.buffer_y[this.length] = y;
            this.buffer_z[this.length] = z;
            this.state[this.length] = s;
            this.item[this.length] = i;
            ++this.length;
        }
    }

    public boolean add(int x, int y, int z, Wand w) {
        BlockState st;
        if (this.length < this.max && (st = w.get_state(y)) != null) {
            Item it = w.get_item(st);
            if (!WandsConfig.denied.contains(st.getBlock())) {
                this.add(x, y, z, st, it);
                return true;
            }
        }
        return false;
    }

    public void set(int i, BlockPos p) {
        this.set(i, p.getX(), p.getY(), p.getZ());
    }

    public void add(BlockPos p, Wand w) {
        this.add(p.getX(), p.getY(), p.getZ(), w);
    }
}

