/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import java.util.Vector;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nicguzzo.wands.items.PaletteItem;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;

public class Palette {
    public static long version = 0L;
    public static long last_version = -1L;
    public ItemStack item = null;
    public boolean has_palette = false;
    public int slot = 0;
    public RandomSource random = RandomSource.create();
    public volatile long seed = System.currentTimeMillis();
    public Vector<PaletteSlot> palette_slots = new Vector();
    public Vector<Vector<PaletteSlot>> palette_grid = new Vector();

    public Palette() {
        for (int i = 0; i < 6; ++i) {
            this.palette_grid.add(new Vector());
        }
    }

    void update_palette(Map<Item, BlockAccounting> block_accounting, Level level) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            if (version == last_version) {
                return;
            }
            version = last_version;
        }
        this.slot = 0;
        if (this.item != null && this.item.getItem() instanceof PaletteItem) {
            PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
            this.palette_slots.clear();
            for (int i = 0; i < 6; ++i) {
                this.palette_grid.get(i).clear();
            }
            CompoundTag tag = Compat.getTags(this.item);
            ListTag palette_inv = tag.getList("Palette", 10);
            int s = palette_inv.size();
            block4: for (int i = 0; i < s; ++i) {
                Block blk;
                CompoundTag stackTag = (CompoundTag)palette_inv.get(i);
                ItemStack stack = ItemStack.EMPTY;
                if (level != null) {
                    stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)stackTag.getCompound("Block")).orElse(ItemStack.EMPTY);
                }
                int inv_slot = stackTag.getInt("Slot");
                if (stack.isEmpty() || (blk = Block.byItem((Item)stack.getItem())) == Blocks.AIR) continue;
                PaletteSlot psl = new PaletteSlot(i, blk.defaultBlockState(), stack);
                if (block_accounting.get(stack.getItem()) == null) {
                    block_accounting.put(stack.getItem(), new BlockAccounting());
                }
                this.palette_slots.add(psl);
                switch (palette_mode) {
                    case GRADIENT: {
                        int j = inv_slot / 9;
                        if (j >= this.palette_grid.size()) continue block4;
                        this.palette_grid.get(j).add(psl);
                    }
                }
            }
        }
    }

    public BlockState get_state(Wand wand, int min, int max, int y) {
        BlockState st = wand.block_state;
        if (!wand.preview) {
            // empty if block
        }
        PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.item);
        int gradient_height = PaletteItem.getGradientHeight(this.item);
        switch (palette_mode) {
            case ROUND_ROBIN: {
                if (this.palette_slots.isEmpty()) break;
                int bound = this.palette_slots.size();
                PaletteSlot ps = this.palette_slots.get(this.slot);
                st = ps.state;
                if (wand.mode == WandProps.Mode.DIRECTION && wand.level.isClientSide()) break;
                this.slot = (this.slot + 1) % bound;
                break;
            }
            case RANDOM: {
                if (this.palette_slots.isEmpty()) break;
                int bound = this.palette_slots.size();
                this.slot = this.random.nextInt(bound);
                PaletteSlot ps = this.palette_slots.get(this.slot);
                st = ps.state;
                Block blk = st.getBlock();
                if (!(blk instanceof SnowLayerBlock)) break;
                int sn = this.random.nextInt(7);
                st = (BlockState)st.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(sn + 1));
                break;
            }
            case GRADIENT: {
                Vector<PaletteSlot> row;
                int bound;
                if (this.palette_grid.isEmpty()) break;
                int bottom_y = wand.pos.getY();
                int mapped_y = WandUtils.mapRange(bottom_y, bottom_y + gradient_height - 1, 5, 0, y);
                if (mapped_y < 0) {
                    mapped_y = 0;
                }
                if (mapped_y > 5) {
                    mapped_y = 5;
                }
                if (mapped_y >= this.palette_grid.size() || (bound = (row = this.palette_grid.get(mapped_y)).size()) <= 0) break;
                this.slot = this.random.nextInt(bound);
                PaletteSlot ps = row.get(this.slot);
                st = ps.state;
            }
        }
        st = wand.state_for_placement(st, null);
        if (PaletteItem.getRotate(this.item)) {
            st = st.getBlock().defaultBlockState().rotate(Rotation.getRandom((RandomSource)this.random));
        }
        return st;
    }

    public boolean state_in_slot(BlockState bs) {
        boolean cond = false;
        if (this.has_palette) {
            for (PaletteSlot slot : this.palette_slots) {
                if (!bs.equals(slot.state)) continue;
                cond = true;
                break;
            }
        }
        return cond;
    }

    public static class PaletteSlot {
        public ItemStack stack;
        public BlockState state;
        public int slot;

        PaletteSlot(int s, BlockState b, ItemStack stk) {
            this.slot = s;
            this.state = b;
            this.stack = stk;
        }
    }
}

