/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand.modes;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.nicguzzo.wands.wand.BlockAccounting;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;

public class BlastMode
extends WandMode {
    @Override
    public void place_in_buffer(Wand wand) {
        wand.block_buffer.reset();
        if (!wand.preview && !wand.creative) {
            wand.block_accounting.clear();
            BlockAccounting ba = new BlockAccounting();
            int rad = WandProps.getVal(wand.wand_stack, WandProps.Value.BLASTRAD);
            int extra_cost = rad - 4;
            ba.needed = 1 + extra_cost;
            wand.block_accounting.put(Items.TNT, ba);
        }
    }

    @Override
    public boolean action(Wand wand) {
        if (wand.can_blast) {
            boolean do_explode = false;
            BlockAccounting ba = null;
            if (wand.creative) {
                do_explode = true;
            } else {
                ba = wand.block_accounting.get(Items.TNT);
                if (ba != null) {
                    boolean bl = do_explode = ba.needed <= ba.in_player;
                }
            }
            if (do_explode) {
                float radius = WandProps.getVal(wand.wand_stack, WandProps.Value.BLASTRAD);
                float eo = 1.0625f;
                if (wand.side == Direction.DOWN) {
                    eo = 0.0625f;
                }
                wand.level.explode((Entity)wand.player, (double)wand.pos.getX(), (double)((float)wand.pos.getY() + eo), (double)wand.pos.getZ(), radius, Level.ExplosionInteraction.BLOCK);
                if (!wand.creative && ba != null) {
                    ba.placed = ba.needed;
                }
                return true;
            }
        }
        return false;
    }
}

