/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand.modes;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.nicguzzo.wands.networking.Networking;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;

public class RockMode
extends WandMode {
    SimplexNoise noise = null;
    public long seed = 123427349L;
    public RandomSource random = RandomSource.create();
    int rx = 0;
    int ry = 0;
    int rz = 0;

    @Override
    public void randomize() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.rx = this.random.nextInt(-1000000, 1000000);
            this.ry = this.random.nextInt(-1000000, 1000000);
            this.rz = this.random.nextInt(-1000000, 1000000);
            this.last_pos = null;
            NetworkManager.sendToServer((CustomPacketPayload)new Networking.SyncRockPacket(this.rx, this.ry, this.rz));
        }
    }

    public void set_random_pos(int _rx, int _ry, int _rz) {
        this.rx = _rx;
        this.ry = _ry;
        this.rz = _rz;
        this.last_pos = null;
    }

    @Override
    public void place_in_buffer(Wand wand) {
        if (this.noise == null) {
            this.random.setSeed(this.seed);
            this.noise = new SimplexNoise(this.random);
            this.randomize();
        }
        if (!this.need_update(wand, true)) {
            return;
        }
        wand.block_buffer.reset();
        if (wand.pos != null) {
            int xc = wand.pos.getX();
            int yc = wand.pos.getY();
            int zc = wand.pos.getZ();
            int r = WandProps.getVal(wand.wand_stack, WandProps.Value.ROCK_RADIUS);
            int nf = WandProps.getVal(wand.wand_stack, WandProps.Value.ROCK_NOISE);
            if (r < 1) {
                return;
            }
            int r2 = r * r;
            int x1 = xc - r;
            int y1 = yc - r;
            int z1 = zc - r;
            int x2 = xc + r;
            int y2 = yc + r;
            int z2 = zc + r;
            int x = -r;
            int i = x1;
            while (i <= x2) {
                int xx = x * x;
                int y = -r;
                int j = y1;
                while (j <= y2) {
                    int yy = y * y;
                    int z = -r;
                    int k = z1;
                    while (k <= z2) {
                        int zz = z * z;
                        double n = this.noise.getValue((double)(x + this.rx), (double)(y + this.ry), (double)(z + this.rz)) * (double)nf;
                        if ((double)(xx + yy + zz) < (double)r2 + n) {
                            wand.add_to_buffer(i, j, k);
                        }
                        ++k;
                        ++z;
                    }
                    ++j;
                    ++y;
                }
                ++i;
                ++x;
            }
            wand.valid = true;
        }
    }
}

