/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.VanillaPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.recipe.EmiSyntheticIngredientRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.runtime.EmiSidebars;
import dev.emi.emi.screen.BoMScreen;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.RecipeScreen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EmiApi {
    private static final Minecraft client = Minecraft.getInstance();

    public static List<EmiStack> getIndexStacks() {
        return EmiStackList.stacks;
    }

    public static EmiRecipeManager getRecipeManager() {
        return EmiRecipes.manager;
    }

    public static boolean isCheatMode() {
        return EmiConfig.cheatMode;
    }

    public static String getSearchText() {
        return EmiScreenManager.search.getValue();
    }

    public static void setSearchText(String text) {
        EmiScreenManager.search.setValue(text);
    }

    public static boolean isSearchFocused() {
        return EmiScreenManager.search.isFocused();
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(mouseX, mouseY, includeStandard);
    }

    public static EmiStackInteraction getHoveredStack(boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(EmiScreenManager.lastMouseX, EmiScreenManager.lastMouseY, includeStandard);
    }

    @Nullable
    public static EmiRecipe getRecipeContext(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            return fav.getRecipe();
        }
        return null;
    }

    public static AbstractContainerScreen<?> getHandledScreen() {
        Screen s = EmiApi.client.screen;
        if (s instanceof AbstractContainerScreen) {
            AbstractContainerScreen hs = (AbstractContainerScreen)s;
            return hs;
        }
        if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            return rs.old;
        }
        if (s instanceof BoMScreen) {
            BoMScreen bs = (BoMScreen)s;
            return bs.old;
        }
        return null;
    }

    public static void displayAllRecipes() {
        EmiRecipeManager manager = EmiApi.getRecipeManager();
        EmiApi.setPages(manager.getCategories().stream().collect(Collectors.toMap(c -> c, c -> manager.getRecipes((EmiRecipeCategory)c))), EmiStack.EMPTY);
    }

    public static void displayRecipeCategory(EmiRecipeCategory category) {
        EmiApi.setPages(Map.of(category, EmiApi.getRecipeManager().getRecipes(category)), EmiStack.EMPTY);
    }

    public static void displayRecipe(EmiRecipe recipe) {
        EmiApi.setPages(Map.of(recipe.getCategory(), List.of(recipe)), EmiStack.EMPTY);
    }

    public static void displayRecipes(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            stack = fav.getStack();
        }
        if (stack instanceof TagEmiIngredient) {
            TagEmiIngredient tag = (TagEmiIngredient)stack;
            for (EmiRecipe recipe : EmiApi.getRecipeManager().getRecipes(VanillaPlugin.TAG)) {
                if (!(recipe instanceof EmiTagRecipe)) continue;
                EmiTagRecipe tr = (EmiTagRecipe)recipe;
                if (!tr.key.equals(tag.key)) continue;
                EmiApi.setPages(Map.of(VanillaPlugin.TAG, List.of(recipe)), stack);
                break;
            }
        } else if (stack instanceof ListEmiIngredient) {
            ListEmiIngredient list = (ListEmiIngredient)stack;
            EmiApi.setPages(Map.of(VanillaPlugin.INGREDIENT, List.of(new EmiSyntheticIngredientRecipe(stack))), stack);
        } else if (stack.getEmiStacks().size() == 1) {
            EmiStack es = stack.getEmiStacks().get(0);
            EmiApi.setPages(EmiApi.mapRecipes(EmiApi.pruneSources(EmiApi.getRecipeManager().getRecipesByOutput(es), es)), stack);
            EmiApi.focusRecipe(BoM.getRecipe(es));
        }
    }

    public static void displayUses(EmiIngredient stack) {
        if (!stack.isEmpty()) {
            EmiStack zero = stack.getEmiStacks().get(0);
            Map<EmiRecipeCategory, List<EmiRecipe>> map = EmiApi.mapRecipes(Stream.concat(EmiApi.pruneUses(EmiApi.getRecipeManager().getRecipesByInput(zero), stack).stream(), EmiRecipes.byWorkstation.getOrDefault(zero, List.of()).stream()).distinct().toList());
            EmiApi.setPages(map, stack);
        }
    }

    public static void viewRecipeTree() {
        Screen s;
        if (EmiApi.client.screen == null) {
            client.setScreen((Screen)new InventoryScreen((Player)EmiApi.client.player));
        }
        if ((s = EmiApi.client.screen) instanceof AbstractContainerScreen) {
            AbstractContainerScreen hs = (AbstractContainerScreen)s;
            EmiApi.push();
            client.setScreen((Screen)new BoMScreen(hs));
        } else if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            EmiApi.push();
            client.setScreen((Screen)new BoMScreen(rs.old));
        }
    }

    public static void focusRecipe(EmiRecipe recipe) {
        Screen screen = EmiApi.client.screen;
        if (screen instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)screen;
            rs.focusRecipe(recipe);
        }
    }

    private static void push() {
        Screen screen = EmiApi.client.screen;
        if (screen instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)screen;
            EmiHistory.push(rs);
        } else {
            screen = EmiApi.client.screen;
            if (screen instanceof BoMScreen) {
                BoMScreen bs = (BoMScreen)screen;
                EmiHistory.push(bs);
            } else {
                EmiHistory.clear();
                EmiHistory.push(EmiApi.client.screen);
            }
        }
    }

    private static List<EmiRecipe> pruneSources(List<EmiRecipe> list, EmiStack context) {
        return list.stream().filter(r -> r.getOutputs().stream().anyMatch(i -> i.isEqual(context))).toList();
    }

    private static List<EmiRecipe> pruneUses(List<EmiRecipe> list, EmiIngredient context) {
        return list.stream().filter(r -> r.getInputs().stream().anyMatch(i -> EmiApi.containsAll(i, context)) || r.getCatalysts().stream().anyMatch(i -> EmiApi.containsAll(i, context))).sorted((a, b) -> EmiApi.getSmallestPresence(a, context) - EmiApi.getSmallestPresence(b, context)).toList();
    }

    private static int getSmallestPresence(EmiRecipe recipe, EmiIngredient context) {
        int ideal = context.getEmiStacks().size();
        int smallestPresence = Integer.MAX_VALUE;
        for (EmiIngredient i : recipe.getInputs()) {
            if (EmiApi.containsAll(i, context) && (smallestPresence = Math.min(smallestPresence, i.getEmiStacks().size())) <= ideal) break;
        }
        return smallestPresence;
    }

    private static Map<EmiRecipeCategory, List<EmiRecipe>> mapRecipes(List<EmiRecipe> list) {
        HashMap map = Maps.newHashMap();
        for (EmiRecipe recipe : list) {
            map.computeIfAbsent(recipe.getCategory(), k -> Lists.newArrayList()).add(recipe);
        }
        return map;
    }

    private static boolean containsAll(EmiIngredient collection, EmiIngredient ingredient) {
        block0: for (EmiStack ing : ingredient.getEmiStacks()) {
            for (EmiStack col : collection.getEmiStacks()) {
                if (!col.isEqual(ing)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static void setPages(Map<EmiRecipeCategory, List<EmiRecipe>> recipes, EmiIngredient stack) {
        if (!(recipes = recipes.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> (EmiRecipeCategory)e.getKey(), e -> (List)e.getValue()))).isEmpty()) {
            Screen screen;
            EmiSidebars.lookup(stack);
            if (EmiApi.getHandledScreen() == null) {
                client.setScreen((Screen)new InventoryScreen((Player)EmiApi.client.player));
            }
            if ((screen = EmiApi.client.screen) instanceof AbstractContainerScreen) {
                AbstractContainerScreen hs = (AbstractContainerScreen)screen;
                EmiApi.push();
                client.setScreen((Screen)new RecipeScreen(hs, recipes));
            } else {
                screen = EmiApi.client.screen;
                if (screen instanceof BoMScreen) {
                    BoMScreen bs = (BoMScreen)screen;
                    EmiApi.push();
                    client.setScreen((Screen)new RecipeScreen(bs.old, recipes));
                } else {
                    screen = EmiApi.client.screen;
                    if (screen instanceof RecipeScreen) {
                        RecipeScreen rs = (RecipeScreen)screen;
                        EmiApi.push();
                        RecipeScreen n = new RecipeScreen(rs.old, recipes);
                        client.setScreen((Screen)n);
                        n.focusCategory(rs.getFocusedCategory());
                    }
                }
            }
        }
    }
}

