/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.mixin.accessor.ItemRendererAccessor;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTextTooltipWrapper;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import dev.emi.emi.screen.tooltip.TagTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class TagEmiIngredient
implements EmiIngredient {
    private final ResourceLocation id;
    private List<EmiStack> stacks;
    public final TagKey<?> key;
    private long amount;
    private float chance = 1.0f;

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, long amount) {
        this(key, EmiTags.getValues(key), amount);
    }

    @ApiStatus.Internal
    public TagEmiIngredient(TagKey<?> key, List<EmiStack> stacks, long amount) {
        this.id = key.location();
        this.key = key;
        this.stacks = stacks;
        this.amount = amount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TagEmiIngredient)) return false;
        TagEmiIngredient tag = (TagEmiIngredient)obj;
        if (!tag.key.equals(this.key)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public EmiIngredient copy() {
        TagEmiIngredient stack = new TagEmiIngredient(this.key, this.amount);
        stack.setChance(this.chance);
        return stack;
    }

    @Override
    public List<EmiStack> getEmiStacks() {
        return this.stacks;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        Minecraft client = Minecraft.getInstance();
        if ((flags & 1) != 0) {
            if (!EmiTags.hasCustomModel(this.key)) {
                if (this.stacks.size() > 0) {
                    this.stacks.get(0).render(context.raw(), x, y, delta, -3);
                }
            } else {
                BakedModel model = EmiAgnos.getBakedTagModel(EmiTags.getCustomModel(this.key));
                context.matrices().pushPose();
                context.matrices().translate((float)(x + 8), (float)(y + 8), 150.0f);
                context.matrices().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                context.matrices().scale(16.0f, 16.0f, 16.0f);
                model.getTransforms().getTransform(ItemDisplayContext.GUI).apply(false, context.matrices());
                context.matrices().translate(-0.5f, -0.5f, -0.5f);
                if (!model.usesBlockLight()) {
                    Lighting.setupForFlatItems();
                }
                MultiBufferSource.BufferSource immediate = context.raw().bufferSource();
                ((ItemRendererAccessor)client.getItemRenderer()).invokeRenderBakedItemModel(model, ItemStack.EMPTY, 0xF000F0, OverlayTexture.NO_OVERLAY, context.matrices(), ItemRenderer.getFoilBufferDirect((MultiBufferSource)immediate, (RenderType)Sheets.translucentCullBlockSheet(), (boolean)true, (boolean)false));
                immediate.endBatch();
                if (!model.usesBlockLight()) {
                    Lighting.setupFor3DItems();
                }
                context.matrices().popPose();
            }
        }
        if ((flags & 2) != 0 && !this.key.registry().equals(EmiPort.getFluidRegistry().key())) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (Component)EmiPort.literal((String)count));
        }
        if ((flags & 4) != 0) {
            EmiRender.renderTagIcon(this, context.raw(), x, y);
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(new EmiTextTooltipWrapper((EmiIngredient)this, EmiPort.ordered(EmiTags.getTagName(this.key))));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal("#" + String.valueOf(this.id), ChatFormatting.DARK_GRAY))));
        }
        if (this.key.registry().equals(EmiPort.getFluidRegistry().key()) && this.amount > 1L) {
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered(EmiRenderHelper.getAmountText((EmiIngredient)this, this.amount))));
        }
        if (EmiConfig.appendModId) {
            String mod = EmiUtil.getModName(this.id.getNamespace());
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal(mod, ChatFormatting.BLUE, ChatFormatting.ITALIC))));
        }
        list.add(new TagTooltipComponent(this.stacks));
        for (EmiStack stack : this.stacks) {
            if (stack.getRemainder().isEmpty()) continue;
            list.add(new RemainderTooltipComponent(this));
            break;
        }
        return list;
    }
}

