/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.alchemy.Potion;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.BeanContext;
import twilightforest.beanification.Component;
import twilightforest.beanification.Configurable;
import twilightforest.init.TFAdvancements;
import twilightforest.util.HolderMatcher;

@Configurable
public class DrinkFromFlaskTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Autowired
    private TriggerInstance.DrinkFromFlaskTriggerInstanceFactory factory;
    @Autowired
    private HolderMatcher holderMatcher;

    public DrinkFromFlaskTrigger() {
        BeanContext.injectInto((Object)this);
    }

    public Codec<TriggerInstance> codec() {
        return this.factory.CODEC;
    }

    public void trigger(ServerPlayer player, int doses, int seconds, Holder<Potion> potion) {
        this.trigger(player, instance -> instance.matches(this, doses, seconds, potion));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints doses, MinMaxBounds.Ints seconds, Holder<Potion> potion) implements SimpleCriterionTrigger.SimpleInstance
    {
        public boolean matches(DrinkFromFlaskTrigger parent, int doses, int seconds, Holder<Potion> potion) {
            return this.doses().matches(doses) && this.seconds().matches(seconds) && parent.holderMatcher.match(this.potion(), potion);
        }

        @Component
        public static class DrinkFromFlaskTriggerInstanceFactory {
            public final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("doses", (Object)MinMaxBounds.Ints.between((int)0, (int)4)).forGetter(TriggerInstance::doses), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("seconds", (Object)MinMaxBounds.Ints.exactly((int)8)).forGetter(TriggerInstance::seconds), (App)BuiltInRegistries.POTION.holderByNameCodec().fieldOf("potion").forGetter(TriggerInstance::potion)).apply((Applicative)instance, TriggerInstance::new));

            public Criterion<TriggerInstance> drankPotion(int doses, MinMaxBounds.Ints seconds, Holder<Potion> potion) {
                return ((DrinkFromFlaskTrigger)((Object)TFAdvancements.DRINK_FROM_FLASK.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), MinMaxBounds.Ints.exactly((int)doses), seconds, potion));
            }

            public Criterion<TriggerInstance> drankPotion(MinMaxBounds.Ints doses, MinMaxBounds.Ints seconds, Holder<Potion> potion) {
                return ((DrinkFromFlaskTrigger)((Object)TFAdvancements.DRINK_FROM_FLASK.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), doses, seconds, potion));
            }
        }
    }
}

