/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GiantBlock
extends Block {
    private boolean isSelfDestructing;

    public GiantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static Iterable<BlockPos> getVolume(BlockPos pos) {
        return BlockPos.betweenClosed((int)(pos.getX() & 0xFFFFFFFC), (int)(pos.getY() & 0xFFFFFFFC), (int)(pos.getZ() & 0xFFFFFFFC), (int)(pos.getX() | 3), (int)(pos.getY() | 3), (int)(pos.getZ() | 3));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (BlockPos dPos : GiantBlock.getVolume(context.getClickedPos())) {
            if (context.getLevel().getBlockState(dPos).canBeReplaced(context)) continue;
            return null;
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide()) {
            for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                level.setBlockAndUpdate(dPos, this.defaultBlockState());
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!this.isSelfDestructing && !this.isVolumeFilled(level, pos)) {
            this.setGiantBlockToAir(level, pos);
        }
    }

    private void setGiantBlockToAir(Level level, BlockPos pos) {
        this.isSelfDestructing = true;
        for (BlockPos iterPos : GiantBlock.getVolume(pos)) {
            if (pos.equals((Object)iterPos) || level.getBlockState(iterPos).getBlock() != this) continue;
            level.destroyBlock(iterPos, false);
        }
        this.isSelfDestructing = false;
    }

    private boolean isVolumeFilled(Level level, BlockPos pos) {
        for (BlockPos dPos : GiantBlock.getVolume(pos)) {
            if (level.getBlockState(dPos).getBlock() == this) continue;
            return false;
        }
        return true;
    }
}

