/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.NagaRenderer;
import twilightforest.entity.boss.Naga;

public class NagaModel<T extends Entity>
extends ListModel<T>
implements TrophyBlockModel {
    private final ModelPart head;
    @Nullable
    private T entity;

    public NagaModel(ModelPart root) {
        this.head = root.getChild("head");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? NagaModel.createJappaModel() : NagaModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -12.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        head.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(84, 0).addBox(-6.0f, 0.0f, -12.0f, 12.0f, 0.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-16.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        T t = this.entity;
        if (t instanceof Naga) {
            Naga naga = (Naga)t;
            this.head.render(stack, builder, light, overlay, FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)color), (int)FastColor.ARGB32.red((int)color), (int)((int)((float)FastColor.ARGB32.green((int)color) - naga.stunlessRedOverlayProgress)), (int)((int)((float)FastColor.ARGB32.blue((int)color) - naga.stunlessRedOverlayProgress))));
        } else {
            this.head.render(stack, builder, light, overlay, color);
        }
        this.entity = null;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        if (JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            stack.scale(0.25f, 0.25f, 0.25f);
            stack.translate(0.0f, -1.5f, 0.0f);
        } else {
            stack.scale(0.5f, 0.5f, 0.5f);
            stack.translate(0.0f, -0.25f, 0.0f);
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)NagaRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
    }
}

