/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import twilightforest.entity.projectile.TFThrowable;

public class CustomProjectileTextureRenderer
extends EntityRenderer<TFThrowable> {
    private final ResourceLocation texture;
    private final float scale;
    private final boolean fullBright;
    private final boolean flashing;

    public CustomProjectileTextureRenderer(EntityRendererProvider.Context ctx, ResourceLocation texture, float scale, boolean fullBright, boolean flashing) {
        super(ctx);
        this.texture = texture;
        this.scale = scale;
        this.fullBright = fullBright;
        this.flashing = flashing;
    }

    public CustomProjectileTextureRenderer(EntityRendererProvider.Context ctx, ResourceLocation texture) {
        this(ctx, texture, 1.0f, false, false);
    }

    protected int getBlockLightLevel(TFThrowable entity, BlockPos pos) {
        return this.fullBright ? 15 : super.getBlockLightLevel((Entity)entity, pos);
    }

    public void render(TFThrowable entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        if (this.flashing) {
            stack.pushPose();
            float age = (float)entity.tickCount + partialTicks;
            float f = (Mth.sin((float)age) + 1.0f) * 0.5f;
            float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            stack.scale(f2, f3, f2);
            this.render(entity, entityYaw, partialTicks, stack, buffer, light, OverlayTexture.pack((int)OverlayTexture.u((float)f), (int)OverlayTexture.v((boolean)false)));
            stack.popPose();
        } else {
            this.render(entity, entityYaw, partialTicks, stack, buffer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    public void render(TFThrowable entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlayTexture) {
        stack.pushPose();
        stack.scale(0.5f * this.scale, 0.5f * this.scale, 0.5f * this.scale);
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose pose = stack.last();
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.texture));
        CustomProjectileTextureRenderer.vertex(consumer, pose, light, 0.0f, 0.0f, 0.0f, 1.0f, overlayTexture);
        CustomProjectileTextureRenderer.vertex(consumer, pose, light, 1.0f, 0.0f, 1.0f, 1.0f, overlayTexture);
        CustomProjectileTextureRenderer.vertex(consumer, pose, light, 1.0f, 1.0f, 1.0f, 0.0f, overlayTexture);
        CustomProjectileTextureRenderer.vertex(consumer, pose, light, 0.0f, 1.0f, 0.0f, 0.0f, overlayTexture);
        stack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, stack, buffer, light);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int light, float xOffset, float zOffset, float u, float v, int overlay) {
        consumer.addVertex(pose, xOffset - 0.5f, zOffset - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(TFThrowable entity) {
        return this.texture;
    }
}

