/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.goal.BreathAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class FireBeetle
extends Monster
implements IBreathAttacker {
    private static final EntityDataAccessor<Boolean> BREATHING = SynchedEntityData.defineId(FireBeetle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int BREATH_DURATION = 10;
    private static final int BREATH_DAMAGE = 2;

    public FireBeetle(EntityType<? extends FireBeetle> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new BreathAttackGoal<FireBeetle>(this, 5.0f, 30, 0.1f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BREATHING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.FIRE_BEETLE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.FIRE_BEETLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.FIRE_BEETLE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound((SoundEvent)TFSounds.FIRE_BEETLE_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.getEntityData().get(BREATHING);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.getEntityData().set(BREATHING, (Object)flag);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isBreathing()) {
            Vec3 look = this.getLookAngle();
            double dist = 0.9;
            double px = this.getX() + look.x() * dist;
            double py = this.getY() + 0.25 + look.y() * dist;
            double pz = this.getZ() + look.z() * dist;
            for (int i = 0; i < 2; ++i) {
                double dx = look.x();
                double dy = look.y();
                double dz = look.z();
                double spread = 5.0 + this.getRandom().nextDouble() * 2.5;
                double velocity = 0.15 + this.getRandom().nextDouble() * 0.15;
                dx += this.getRandom().nextGaussian() * 0.0075 * spread;
                dy += this.getRandom().nextGaussian() * 0.0075 * spread;
                dz += this.getRandom().nextGaussian() * 0.0075 * spread;
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
            this.playSound((SoundEvent)TFSounds.FIRE_BEETLE_SHOOT.get(), this.getRandom().nextFloat() * 0.5f, this.getRandom().nextFloat() * 0.5f);
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        }
    }

    public int getMaxHeadXRot() {
        return 500;
    }

    @Override
    public void doBreathAttack(Entity target) {
        if (!target.fireImmune() && target.hurt(TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.SCORCHED, (Entity)this, new EntityType[0]), 2.0f)) {
            target.igniteForSeconds(10.0f);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (this.isBreathing()) {
            return entity.hurt(TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.SCORCHED, (Entity)this, new EntityType[0]), 2.0f);
        }
        return super.doHurtTarget(entity);
    }
}

