/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.StructureTagGenerator;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFDataMaps;
import twilightforest.init.TFItems;
import twilightforest.item.mapdata.TFMagicMapData;
import twilightforest.util.datamaps.MagicMapBiomeColor;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;
import twilightforest.world.components.structures.util.LandmarkStructure;

public class MagicMapItem
extends MapItem {
    public static final String STR_ID = "magicmap";
    private static final Map<ChunkPos, Holder<Biome>[]> CACHE = new HashMap<ChunkPos, Holder<Biome>[]>();

    public MagicMapItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack setupNewMap(Level level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack((ItemLike)TFItems.FILLED_MAGIC_MAP.get());
        MagicMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (ResourceKey<Level>)level.dimension());
        return itemstack;
    }

    @Nullable
    public static TFMagicMapData getData(ItemStack stack, Level level) {
        MapId mapid = (MapId)stack.get(DataComponents.MAP_ID);
        return mapid == null ? null : TFMagicMapData.getMagicMapData(level, MagicMapItem.getMapName(mapid.id()));
    }

    @Nullable
    public static TFMagicMapData getData(ItemStack stack, Item.TooltipContext context) {
        TFMagicMapData mapData;
        MapItemSavedData mapItemSavedData;
        MapId mapid = (MapId)stack.get(DataComponents.MAP_ID);
        return mapid != null && (mapItemSavedData = context.mapData(mapid)) instanceof TFMagicMapData ? (mapData = (TFMagicMapData)mapItemSavedData) : null;
    }

    @Nullable
    protected TFMagicMapData getCustomMapData(ItemStack stack, Level level) {
        TFMagicMapData mapdata = MagicMapItem.getData(stack, level);
        if (mapdata == null && !level.isClientSide()) {
            BlockPos sharedSpawnPos = level.getSharedSpawnPos();
            mapdata = MagicMapItem.createMapData(stack, level, sharedSpawnPos.getX(), sharedSpawnPos.getZ(), 3, false, false, (ResourceKey<Level>)level.dimension());
        }
        return mapdata;
    }

    public static ColumnPos getMagicMapCenter(int x, int z) {
        int mapSize = 2048;
        int roundX = (int)Math.round((double)(x - 1024) / (double)mapSize);
        int roundZ = (int)Math.round((double)(z - 1024) / (double)mapSize);
        int scaledX = roundX * mapSize + 1024;
        int scaledZ = roundZ * mapSize + 1024;
        return new ColumnPos(scaledX, scaledZ);
    }

    private static TFMagicMapData createMapData(ItemStack stack, Level level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<Level> dimension) {
        MapId freeMapId = level.getFreeMapId();
        ColumnPos pos = MagicMapItem.getMagicMapCenter(x, z);
        TFMagicMapData mapdata = new TFMagicMapData(pos.x(), pos.z(), (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        TFMagicMapData.registerMagicMapData(level, mapdata, MagicMapItem.getMapName(freeMapId.id()));
        stack.set(DataComponents.MAP_ID, (Object)freeMapId);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "magicmap_" + id;
    }

    public void update(Level level, Entity viewer, MapItemSavedData data) {
        if (level.dimension() == data.dimension && viewer instanceof Player && !level.isClientSide) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.centerX;
            int centerZ = data.centerZ;
            int viewerX = Mth.floor((double)(viewer.getX() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = Mth.floor((double)(viewer.getZ() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Holder[] biomes = CACHE.computeIfAbsent(new ChunkPos(startX, startZ), pos -> {
                Holder[] array = new Holder[128 * biomesPerPixel * 128 * biomesPerPixel];
                for (int l = 0; l < 128 * biomesPerPixel; ++l) {
                    for (int i1 = 0; i1 < 128 * biomesPerPixel; ++i1) {
                        array[l * 128 * biomesPerPixel + i1] = level.getBiome(new BlockPos(startX * biomesPerPixel + i1 * biomesPerPixel, 0, startZ * biomesPerPixel + l * biomesPerPixel));
                    }
                }
                return array;
            });
            Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    ResourceKey<Structure> structureKey;
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Holder biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Holder overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Holder downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    biome = overBiome != null && overBiome.is(TFBiomes.STREAM) ? overBiome : (downBiome != null && downBiome.is(TFBiomes.STREAM) ? downBiome : biome);
                    MagicMapBiomeColor colorBrightness = this.getMapColorPerBiome((Holder<Biome>)biome);
                    MapColor mapcolor = colorBrightness.color();
                    int brightness = colorBrightness.brightness();
                    if (xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.colors[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.id * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.setColor(xPixel, zPixel, ourPixel);
                        data.setDirty();
                    }
                    if (!LegacyLandmarkPlacements.blockIsInLandmarkCenter(worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel) || !structureRegistry.getHolder(structureKey = LegacyLandmarkPlacements.pickLandmarkAtBlock(worldX, worldZ, (LevelReader)level)).map(structureRef -> structureRef.is(StructureTagGenerator.LANDMARK)).orElse(false).booleanValue()) continue;
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    Object object = structureRegistry.getOrThrow(structureKey);
                    if (!(object instanceof LandmarkStructure)) continue;
                    LandmarkStructure landmark = (LandmarkStructure)object;
                    landmark.getMapIcon().ifPresent(icon -> tfData.addTFDecoration((Holder<MapDecorationType>)icon, (LevelAccessor)level, MagicMapItem.makeName((Holder<MapDecorationType>)icon, worldX, worldZ), worldX, worldZ, 180.0, LandmarkUtil.isConquered(level, worldX, worldZ)));
                }
            }
        }
    }

    public static String makeName(Holder<MapDecorationType> type, int x, int z) {
        return String.valueOf(((MapDecorationType)type.value()).assetId()) + "_" + x + "_" + z;
    }

    private MagicMapBiomeColor getMapColorPerBiome(Holder<Biome> biome) {
        MagicMapBiomeColor color = (MagicMapBiomeColor)biome.getData(TFDataMaps.MAGIC_MAP_BIOME_COLOR);
        return color != null ? color : new MagicMapBiomeColor(MapColor.COLOR_MAGENTA);
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
    }

    @Nullable
    public Packet<?> getUpdatePacket(ItemStack stack, Level world, Player player) {
        MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
        TFMagicMapData mapdata = this.getCustomMapData(stack, world);
        return mapId == null || mapdata == null ? null : mapdata.getUpdatePacket(mapId, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
        if (mapId != null) {
            if (flag.isAdvanced()) {
                TFMagicMapData mapitemsaveddata = TFMagicMapData.getClientMagicMapData(MagicMapItem.getMapName(mapId.id()));
                if (mapitemsaveddata != null) {
                    tooltip.add((Component)Component.translatable((String)"filled_map.id", (Object[])new Object[]{mapId.id()}).withStyle(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.translatable((String)"filled_map.scale", (Object[])new Object[]{1 << mapitemsaveddata.scale}).withStyle(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.translatable((String)"filled_map.level", (Object[])new Object[]{mapitemsaveddata.scale, 4}).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.translatable((String)"filled_map.unknown").withStyle(ChatFormatting.GRAY));
                }
            } else {
                tooltip.add(MapItem.getTooltipForId((MapId)mapId));
            }
        }
    }
}

