/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFDataComponents;

public interface StructureHints {
    public static final String BOOK_AUTHOR = "twilightforest.book.author";

    default public ItemStack createHintBook(RegistryAccess registryAccess) {
        ItemStack book = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        this.addBookInformation(book);
        return book;
    }

    default public void addBookInformation(ItemStack book) {
        StructureHints.addBookInformationStatic(book, "unknown", 2);
    }

    public static void addBookInformationStatic(ItemStack book, @Nullable String name, int pageCount) {
        String key = name == null ? "unknown" : name;
        Function<Integer, Filterable> pageGenerationFunc = index -> Filterable.passThrough((Object)Component.translatable((String)("twilightforest.book." + key + "." + (index + 1))));
        List<Filterable> list = Stream.iterate(0, index -> index + 1).limit(pageCount).map(pageGenerationFunc).toList();
        book.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(Filterable.passThrough((Object)("twilightforest.book." + key)), BOOK_AUTHOR, 3, list, true));
        book.set(TFDataComponents.TRANSLATABLE_BOOK, (Object)Unit.INSTANCE);
    }

    default public void trySpawnHintMonster(Level world, Player player) {
        this.trySpawnHintMonster(world, player, player.blockPosition());
    }

    public void trySpawnHintMonster(Level var1, Player var2, BlockPos var3);

    public static void tryHintForStructure(Player player, ServerLevel level, ResourceKey<Structure> forStructure) {
        Object object;
        Optional optStructureReg = level.registryAccess().registry(Registries.STRUCTURE);
        if (optStructureReg.isEmpty() || !((object = ((Registry)optStructureReg.get()).get(forStructure)) instanceof StructureHints)) {
            return;
        }
        StructureHints structureHints = (StructureHints)object;
        structureHints.trySpawnHintMonster((Level)level, player);
    }

    default public boolean didSpawnHintMonster(Level world, Player player, BlockPos pos) {
        int dx = world.random.nextInt(16) - world.random.nextInt(16);
        int dy = world.random.nextInt(4) - world.random.nextInt(4);
        int dz = world.random.nextInt(16) - world.random.nextInt(16);
        Mob hinty = this.createHintMonster(world);
        hinty.moveTo(pos.offset(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.checkSpawnObstruction((LevelReader)world) && hinty.getSensing().hasLineOfSight((Entity)player)) {
            ItemStack book = this.createHintBook(world.registryAccess());
            hinty.setItemSlot(EquipmentSlot.MAINHAND, book);
            hinty.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
            world.addFreshEntity((Entity)hinty);
            return true;
        }
        return false;
    }

    @Nullable
    public Mob createHintMonster(Level var1);

    public record HintConfig(ItemStack hintItem, EntityType<? extends Mob> hintMob) {
        public static final MapCodec<HintConfig> FLAT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("hint_item").forGetter(HintConfig::hintItem), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().comapFlatMap(HintConfig::checkCastMob, entityType -> entityType).fieldOf("hint_mob").forGetter(HintConfig::hintMob)).apply((Applicative)instance, HintConfig::new));
        public static Codec<HintConfig> CODEC = FLAT_CODEC.codec();

        private static DataResult<EntityType<? extends Mob>> checkCastMob(EntityType<?> entityType) {
            if (!entityType.getBaseClass().isAssignableFrom(Mob.class)) {
                return DataResult.error(() -> "Configured Hint Entity " + entityType.toShortString() + " does not have a `Mob` superclass!");
            }
            return DataResult.success(entityType);
        }

        public static ItemStack defaultBook() {
            return HintConfig.book("unknown", 2);
        }

        public static ItemStack book(String name, int pageCount) {
            ItemStack book = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
            StructureHints.addBookInformationStatic(book, name, pageCount);
            return book;
        }
    }
}

