/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.nbt.validators.Validator;
import com.teamresourceful.resourcefullib.common.nbt.validators.list.ListValidator;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import com.teamresourceful.resourcefullib.common.nbt.validators.object.ObjectValidator;
import com.teamresourceful.resourcefullib.common.nbt.validators.string.StringValidator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class FullValidatorCodec
implements Codec<Validator<?>> {
    public static final Codec<Validator<?>> CODEC = new FullValidatorCodec();

    private FullValidatorCodec() {
    }

    public <T> DataResult<Pair<Validator<?>, T>> decode(DynamicOps<T> ops, T input) {
        return FullValidatorCodec.decode(ops, input, ListValidator.CODEC, NumericValidator.CODEC, ObjectValidator.CODEC, StringValidator.CODEC);
    }

    public <T> DataResult<T> encode(Validator<?> input, DynamicOps<T> ops, T prefix) {
        if (input instanceof ListValidator) {
            ListValidator listValidator = (ListValidator)input;
            return ListValidator.CODEC.encode((Object)listValidator, ops, prefix);
        }
        if (input instanceof NumericValidator) {
            NumericValidator numericValidator = (NumericValidator)input;
            return NumericValidator.CODEC.encode((Object)numericValidator, ops, prefix);
        }
        if (input instanceof ObjectValidator) {
            ObjectValidator objectValidator = (ObjectValidator)input;
            return ObjectValidator.CODEC.encode((Object)objectValidator, ops, prefix);
        }
        if (input instanceof StringValidator) {
            StringValidator stringValidator = (StringValidator)input;
            return StringValidator.CODEC.encode((Object)stringValidator, ops, prefix);
        }
        return DataResult.error(() -> "Failed to encode validator.");
    }

    @SafeVarargs
    private static <T> DataResult<? extends Pair<? extends Validator<?>, T>> decode(DynamicOps<T> ops, T input, Codec<? extends Validator<?>> ... codecs) {
        for (Codec<? extends Validator<?>> codec : codecs) {
            DataResult result = codec.decode(ops, input);
            if (!result.result().isPresent()) continue;
            return result;
        }
        return DataResult.error(() -> "Failed to decode validator.");
    }
}

