/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.ends_delight.block;

import cn.foggyhillside.ends_delight.registry.ModItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class DragonLegBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<DragonLegBlock> CODEC = DragonLegBlock.simpleCodec(DragonLegBlock::new);
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)6);
    protected static final VoxelShape[] SHAPES_NORTH_HEAD = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)5.0, (double)5.0), Block.box((double)6.0, (double)5.0, (double)0.0, (double)10.0, (double)15.0, (double)1.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)8.0, (double)5.0), Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)15.0, (double)1.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)3.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)6.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)9.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)12.0))};
    protected static final VoxelShape[] SHAPES_NORTH_FOOT = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)2.0, (double)11.0, (double)10.0, (double)6.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)5.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)13.0, (double)10.0, (double)15.0, (double)16.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)8.0, (double)16.0), Block.box((double)6.0, (double)8.0, (double)13.0, (double)10.0, (double)15.0, (double)16.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)13.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)13.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)13.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)13.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)10.0)})};
    protected static final VoxelShape[] SHAPES_SOUTH_HEAD = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)2.0, (double)11.0, (double)10.0, (double)6.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)11.0, (double)14.0, (double)5.0, (double)16.0), Block.box((double)6.0, (double)5.0, (double)15.0, (double)10.0, (double)15.0, (double)16.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)11.0, (double)14.0, (double)8.0, (double)16.0), Block.box((double)6.0, (double)8.0, (double)15.0, (double)10.0, (double)15.0, (double)16.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)13.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)13.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)13.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)13.0, (double)16.0))};
    protected static final VoxelShape[] SHAPES_SOUTH_FOOT = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)5.0, (double)6.0), Block.box((double)6.0, (double)5.0, (double)0.0, (double)10.0, (double)15.0, (double)3.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)8.0, (double)6.0), Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)15.0, (double)3.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)6.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)13.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)6.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)13.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)6.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)13.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)13.0, (double)6.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)13.0)})};
    protected static final VoxelShape[] SHAPES_WEST_HEAD = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)6.0, (double)5.0, (double)6.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)5.0, (double)5.0, (double)14.0), Block.box((double)0.0, (double)5.0, (double)6.0, (double)1.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)5.0, (double)8.0, (double)14.0), Block.box((double)0.0, (double)8.0, (double)6.0, (double)1.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)9.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)13.0, (double)14.0))};
    protected static final VoxelShape[] SHAPES_WEST_FOOT = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)11.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), Block.box((double)13.0, (double)5.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0), Block.box((double)13.0, (double)8.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)3.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)})};
    protected static final VoxelShape[] SHAPES_EAST_HEAD = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)11.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)2.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), Block.box((double)15.0, (double)5.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)2.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0), Block.box((double)15.0, (double)8.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0))};
    protected static final VoxelShape[] SHAPES_EAST_FOOT = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)6.0, (double)5.0, (double)6.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)5.0, (double)14.0), Block.box((double)0.0, (double)5.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)8.0, (double)14.0), Block.box((double)0.0, (double)8.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)13.0, (double)14.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)13.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)13.0, (double)14.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)13.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)13.0, (double)14.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)13.0, (double)9.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)13.0, (double)14.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)13.0, (double)9.0, (double)10.0)})};

    public DragonLegBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(6))).setValue(PART, (Comparable)BedPart.HEAD));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue(PART) == BedPart.HEAD) {
            switch ((Direction)pState.getValue((Property)FACING)) {
                case NORTH: {
                    return SHAPES_NORTH_HEAD[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case SOUTH: {
                    return SHAPES_SOUTH_HEAD[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case WEST: {
                    return SHAPES_WEST_HEAD[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case EAST: {
                    return SHAPES_EAST_HEAD[(Integer)pState.getValue((Property)SERVINGS)];
                }
            }
        }
        if (pState.getValue(PART) == BedPart.FOOT) {
            switch ((Direction)pState.getValue((Property)FACING)) {
                case NORTH: {
                    return SHAPES_NORTH_FOOT[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case SOUTH: {
                    return SHAPES_SOUTH_FOOT[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case WEST: {
                    return SHAPES_WEST_FOOT[(Integer)pState.getValue((Property)SERVINGS)];
                }
                case EAST: {
                    return SHAPES_EAST_FOOT[(Integer)pState.getValue((Property)SERVINGS)];
                }
            }
        }
        return SHAPES_NORTH_HEAD[(Integer)pState.getValue((Property)SERVINGS)];
    }

    private static Direction getNeighbourDirection(BedPart pPart, Direction pDirection) {
        return pPart == BedPart.HEAD ? pDirection : pDirection.getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, SERVINGS, PART});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == DragonLegBlock.getNeighbourDirection((BedPart)pState.getValue(PART), (Direction)pState.getValue((Property)FACING))) {
            return pState.canSurvive((LevelReader)pLevel, pPos) && pNeighborState.is((Block)this) && pNeighborState.getValue(PART) != pState.getValue(PART) ? pState : Blocks.AIR.defaultBlockState();
        }
        return !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!pLevel.isClientSide && pPlayer.isCreative() && (bedpart = (BedPart)pState.getValue(PART)) == BedPart.FOOT && (blockstate = pLevel.getBlockState(blockpos = pPos.relative(DragonLegBlock.getNeighbourDirection(bedpart, (Direction)pState.getValue((Property)FACING))))).is((Block)this) && blockstate.getValue(PART) == BedPart.HEAD) {
            pLevel.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            pLevel.levelEvent(pPlayer, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getHorizontalDirection();
        BlockPos blockpos = pContext.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        Level level = pContext.getLevel();
        return level.getBlockState(blockpos1).canBeReplaced(pContext) && level.getWorldBorder().isWithinBounds(blockpos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.isClientSide) {
            BlockPos facingPos = pPos.relative((Direction)pState.getValue((Property)FACING));
            pLevel.setBlock(facingPos, (BlockState)pState.setValue(PART, (Comparable)BedPart.FOOT), 3);
            pLevel.blockUpdated(pPos, Blocks.AIR);
            pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        int servings = (Integer)pState.getValue((Property)SERVINGS);
        ItemStack heldStack = pPlayer.getItemInHand(pHand);
        if (servings != 0) {
            if (heldStack.is(Items.BOWL)) {
                return this.takeServing(pLevel, pPos, pState, pPlayer, pHand, (Item)ModItems.DRAGON_LEG_WITH_SAUCE.get());
            }
            pPlayer.displayClientMessage((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{new ItemStack((ItemLike)Items.BOWL).getHoverName()}), true);
        }
        if (servings == 0) {
            pLevel.playSound(null, pPos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            pLevel.destroyBlock(pPos, true);
        } else {
            pPlayer.displayClientMessage((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{new ItemStack((ItemLike)Items.BOWL).getHoverName()}), true);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected ItemInteractionResult takeServing(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, Item serving) {
        int servings = (Integer)pState.getValue((Property)SERVINGS);
        BedPart part = (BedPart)pState.getValue(PART);
        BlockPos pairPos = pPos.relative(DragonLegBlock.getNeighbourDirection(part, (Direction)pState.getValue((Property)FACING)));
        BlockState pairState = pLevel.getBlockState(pairPos);
        ItemStack heldItem = pPlayer.getItemInHand(pHand);
        pLevel.setBlock(pairPos, (BlockState)pairState.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        if (!pPlayer.isCreative()) {
            heldItem.shrink(1);
        }
        if (!pPlayer.getInventory().add(new ItemStack((ItemLike)serving))) {
            pPlayer.drop(new ItemStack((ItemLike)serving), false);
        }
        pLevel.playSound(null, pPos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }
}

