/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.infiniverse.internal;

import com.google.common.collect.Lists;
import com.ibm.icu.impl.locale.XCldrStub;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.commoble.infiniverse.api.InfiniverseAPI;
import net.commoble.infiniverse.api.UnregisterDimensionEvent;
import net.commoble.infiniverse.internal.QuietPacketDistributors;
import net.commoble.infiniverse.internal.ReflectionBuddy;
import net.commoble.infiniverse.internal.UpdateDimensionsPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DimensionManager
implements InfiniverseAPI {
    private static final RegistrationInfo DIMENSION_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.stable());
    public static final DimensionManager INSTANCE = new DimensionManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ResourceKey<Level>> VANILLA_LEVELS = Set.of(Level.OVERWORLD, Level.NETHER, Level.END);
    private Set<ResourceKey<Level>> levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();

    private DimensionManager() {
    }

    @Override
    public ServerLevel getOrCreateLevel(MinecraftServer server, ResourceKey<Level> levelKey, Supplier<LevelStem> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(levelKey);
        return existingLevel == null ? DimensionManager.createAndRegisterLevel(server, map, levelKey, dimensionFactory) : existingLevel;
    }

    @Override
    public void markDimensionForUnregistration(MinecraftServer server, ResourceKey<Level> levelToRemove) {
        ServerLevel level;
        if (!VANILLA_LEVELS.contains(levelToRemove) && (level = server.getLevel(levelToRemove)) != null) {
            level.save(null, true, false);
            this.levelsPendingUnregistration.add(levelToRemove);
        }
    }

    @Override
    public Set<ResourceKey<Level>> getLevelsPendingUnregistration() {
        return XCldrStub.ImmutableSet.copyOf(this.levelsPendingUnregistration);
    }

    private static ServerLevel createAndRegisterLevel(MinecraftServer server, Map<ResourceKey<Level>, ServerLevel> map, ResourceKey<Level> levelKey, Supplier<LevelStem> dimensionFactory) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)levelKey.location());
        LevelStem dimension = dimensionFactory.get();
        ChunkProgressListener chunkProgressListener = ReflectionBuddy.MinecraftServerAccess.progressListenerFactory.apply(server).create(11);
        Executor executor = ReflectionBuddy.MinecraftServerAccess.executor.apply(server);
        LevelStorageSource.LevelStorageAccess anvilConverter = ReflectionBuddy.MinecraftServerAccess.storageSource.apply(server);
        WorldData worldData = server.getWorldData();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.overworldData());
        Registry dimensionRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        if (!(dimensionRegistry instanceof MappedRegistry)) {
            throw new IllegalStateException(String.format("Unable to register dimension %s -- dimension registry not writable", dimensionKey.location()));
        }
        MappedRegistry writableRegistry = (MappedRegistry)dimensionRegistry;
        writableRegistry.unfreeze();
        writableRegistry.register(dimensionKey, (Object)dimension, DIMENSION_REGISTRATION_INFO);
        ServerLevel newLevel = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, levelKey, dimension, chunkProgressListener, worldData.isDebugWorld(), overworld.getSeed(), List.of(), false, (RandomSequences)null);
        overworld.getWorldBorder().addListener((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newLevel.getWorldBorder()));
        map.put(levelKey, newLevel);
        server.markWorldsDirty();
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
        QuietPacketDistributors.sendToAll(server, new UpdateDimensionsPacket(Set.of(levelKey), true));
        return newLevel;
    }

    private void unregisterScheduledDimensions(MinecraftServer server) {
        if (this.levelsPendingUnregistration.isEmpty()) {
            return;
        }
        Set<ResourceKey<Level>> keysToRemove = this.levelsPendingUnregistration;
        this.levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();
        Registry oldRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        if (!(oldRegistry instanceof MappedRegistry)) {
            LOGGER.warn("Cannot unload dimensions: dimension registry not an instance of MappedRegistry. There may be another mod causing incompatibility with Infiniverse, or Infiniverse may need to be updated for your version of forge/minecraft.");
            return;
        }
        MappedRegistry oldMappedRegistry = (MappedRegistry)oldRegistry;
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReflectionBuddy.MinecraftServerAccess.registries.apply(server);
        RegistryAccess.Frozen composite = ReflectionBuddy.LayeredRegistryAccessAccess.composite.apply(layeredRegistryAccess);
        if (!(composite instanceof RegistryAccess.ImmutableRegistryAccess)) {
            LOGGER.warn("Cannot unload dimensions: composite registry not an instance of ImmutableRegistryAccess. There may be another mod causing incompatibility with Infiniverse, or Infiniverse may be updated for your version of forge/minecraft.");
            return;
        }
        RegistryAccess.ImmutableRegistryAccess immutableRegistryAccess = (RegistryAccess.ImmutableRegistryAccess)composite;
        HashSet<ResourceKey<Level>> removedLevelKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        for (ResourceKey<Level> resourceKey : keysToRemove) {
            ServerLevel removedLevel;
            ServerLevel levelToRemove = server.getLevel(resourceKey);
            if (levelToRemove == null) continue;
            UnregisterDimensionEvent unregisterDimensionEvent = new UnregisterDimensionEvent(levelToRemove);
            NeoForge.EVENT_BUS.post((Event)unregisterDimensionEvent);
            if (unregisterDimensionEvent.isCanceled() || (removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(resourceKey)) == null) continue;
            for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.players())) {
                BlockPos destinationPos;
                ServerLevel destinationLevel;
                ResourceKey respawnKey = player.getRespawnDimension();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = Level.OVERWORLD;
                    player.setRespawnPosition(respawnKey, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = Level.OVERWORLD;
                }
                if ((destinationLevel = server.getLevel(respawnKey)) == null) {
                    destinationLevel = overworld;
                }
                if ((destinationPos = player.getRespawnPosition()) == null) {
                    destinationPos = destinationLevel.getSharedSpawnPos();
                }
                float respawnAngle = player.getRespawnAngle();
                player.teleportTo(destinationLevel, (double)destinationPos.getX(), (double)destinationPos.getY(), (double)destinationPos.getZ(), respawnAngle, 0.0f);
            }
            removedLevel.save(null, false, removedLevel.noSave());
            NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)removedLevel));
            WorldBorder overworldBorder = overworld.getWorldBorder();
            WorldBorder removedWorldBorder = removedLevel.getWorldBorder();
            List<BorderChangeListener> listeners = ReflectionBuddy.WorldBorderAccess.listeners.apply(overworldBorder);
            BorderChangeListener targetListener = null;
            for (BorderChangeListener listener : listeners) {
                BorderChangeListener.DelegateBorderChangeListener delegate;
                if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ReflectionBuddy.DelegateBorderChangeListenerAccess.worldBorder.apply(delegate = (BorderChangeListener.DelegateBorderChangeListener)listener)) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.removeListener(targetListener);
            }
            removedLevelKeys.add(resourceKey);
        }
        if (!removedLevelKeys.isEmpty()) {
            MappedRegistry newRegistry = new MappedRegistry(Registries.LEVEL_STEM, oldMappedRegistry.registryLifecycle());
            for (RegistryLayer[] entry : oldRegistry.entrySet()) {
                ResourceKey oldKey = (ResourceKey)entry.getKey();
                ResourceKey oldLevelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)oldKey.location());
                LevelStem dimension = (LevelStem)entry.getValue();
                if (oldKey == null || dimension == null || removedLevelKeys.contains(oldLevelKey)) continue;
                newRegistry.register(oldKey, (Object)dimension, oldRegistry.registrationInfo(oldKey).orElse(DIMENSION_REGISTRATION_INFO));
            }
            ArrayList<RegistryAccess.Frozen> arrayList = new ArrayList<RegistryAccess.Frozen>();
            for (RegistryLayer layer : RegistryLayer.values()) {
                if (layer == RegistryLayer.DIMENSIONS) {
                    arrayList.add(new RegistryAccess.ImmutableRegistryAccess(List.of(newRegistry)).freeze());
                    continue;
                }
                arrayList.add(layeredRegistryAccess.getLayer((Object)layer));
            }
            HashMap<ResourceKey, Registry> newRegistryMap = new HashMap<ResourceKey, Registry>();
            for (RegistryAccess.Frozen registryAccess : arrayList) {
                List registries = registryAccess.registries().toList();
                for (RegistryAccess.RegistryEntry registryEntry : registries) {
                    newRegistryMap.put(registryEntry.key(), registryEntry.value());
                }
            }
            ReflectionBuddy.LayeredRegistryAccessAccess.values.set(layeredRegistryAccess, List.copyOf(arrayList));
            ReflectionBuddy.ImmutableRegistryAccessAccess.registries.set(immutableRegistryAccess, newRegistryMap);
            server.markWorldsDirty();
            QuietPacketDistributors.sendToAll(server, new UpdateDimensionsPacket(removedLevelKeys, false));
        }
    }

    @EventBusSubscriber(modid="infiniverse")
    private static class ForgeEventHandler {
        private ForgeEventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onServerTick(ServerTickEvent.Post event) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                INSTANCE.unregisterScheduledDimensions(server);
            }
        }

        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            DimensionManager.INSTANCE.levelsPendingUnregistration = new HashSet<ResourceKey<Level>>();
        }
    }
}

