/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15;

import com.medsal15.ClientConfig;
import com.medsal15.ESSounds;
import com.medsal15.ServerConfig;
import com.medsal15.blockentities.ESBlockEntities;
import com.medsal15.blocks.ESBlocks;
import com.medsal15.client.model.armor.HeavyBootsModel;
import com.medsal15.entities.ESArrowRenderer;
import com.medsal15.entities.ESEntities;
import com.medsal15.entities.projectiles.CaptainJusticeShield;
import com.medsal15.interpreters.ESInterpretertypes;
import com.medsal15.items.ESArmorMaterials;
import com.medsal15.items.ESDataComponents;
import com.medsal15.items.ESEnergyStorage;
import com.medsal15.items.ESItems;
import com.medsal15.items.guns.ESGun;
import com.medsal15.items.guns.GunContainer;
import com.medsal15.items.shields.ESShield;
import com.medsal15.loot_modifiers.ESLootModifiers;
import com.medsal15.mobeffects.ESMobEffects;
import com.medsal15.modus.ESModus;
import com.medsal15.structures.processors.ESProcessors;
import com.mojang.logging.LogUtils;
import java.text.NumberFormat;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="extrastuck")
public class ExtraStuck {
    public static final String MODID = "extrastuck";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"extrastuck");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MOD_TAB = CREATIVE_MODE_TABS.register("extrastuck_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.extrastuck")).icon(() -> ((Item)ESItems.WOODEN_SHIELD.get()).getDefaultInstance()).displayItems(ESItems::addToCreativeTab).build());

    public static ResourceLocation modid(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public ExtraStuck(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(this::onShieldBlock);
        NeoForge.EVENT_BUS.addListener(this::onDamage);
        NeoForge.EVENT_BUS.addListener(this::modifyFov);
        modEventBus.addListener(this::registerCapabilities);
        ESArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        ESBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ESBlocks.BLOCKS.register(modEventBus);
        ESDataComponents.DATA_COMPONENTS.register(modEventBus);
        ESEntities.ENTITIES.register(modEventBus);
        ESInterpretertypes.INTERPRETER_TYPES.register(modEventBus);
        ESItems.ITEMS.register(modEventBus);
        ESLootModifiers.GLM_SERIALIZERS.register(modEventBus);
        ESMobEffects.MOB_EFFECTS.register(modEventBus);
        ESModus.MODUSES.register(modEventBus);
        ESProcessors.PROCESSORS.register(modEventBus);
        ESSounds.SOUND_EVENTS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, u) -> new ESEnergyStorage((ItemStack)stack), new ItemLike[]{(ItemLike)ESItems.FLUX_SHIELD.get(), (ItemLike)ESItems.OVERCHARGED_MAGNEFORK.get(), (ItemLike)ESItems.UNDERCHARGED_MAGNEFORK.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, u) -> new GunContainer(1, (ItemStack)stack), new ItemLike[]{(ItemLike)ESItems.HANDGUN.get()});
    }

    @SubscribeEvent
    public void onShieldBlock(LivingShieldBlockEvent event) {
        Item item = event.getEntity().getUseItem().getItem();
        if (item instanceof ESShield) {
            ESShield shield = (ESShield)item;
            shield.onShieldBlock(event);
            return;
        }
    }

    @SubscribeEvent
    public void onDamage(LivingIncomingDamageEvent event) {
        InteractionHand hand;
        LivingEntity entity = event.getEntity();
        if (entity.getHealth() > event.getAmount()) {
            return;
        }
        if (entity.getMainHandItem().is(ESItems.ANTI_DIE)) {
            hand = InteractionHand.MAIN_HAND;
        } else if (entity.getOffhandItem().is(ESItems.ANTI_DIE)) {
            hand = InteractionHand.OFF_HAND;
        } else {
            return;
        }
        entity.playSound(SoundEvents.TOTEM_USE);
        Minecraft minecraft = Minecraft.getInstance();
        GameRenderer renderer = minecraft.gameRenderer;
        renderer.displayItemActivation(ESItems.ANTI_DIE.toStack());
        event.setCanceled(true);
        entity.setItemInHand(hand, ItemStack.EMPTY);
    }

    @SubscribeEvent
    public void modifyFov(ComputeFovModifierEvent event) {
        Item item;
        Player player = event.getPlayer();
        ItemStack stack = player.getUseItem();
        float zoom = 1.0f;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ESGun) {
            ESGun gun = (ESGun)item;
            zoom = gun.getZoom();
        }
        if (zoom != 1.0f) {
            event.setNewFovModifier(zoom);
        }
    }

    @EventBusSubscriber(modid="extrastuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ClientGameEvents {
        @SubscribeEvent
        public static void addCustomTooltip(ItemTooltipEvent event) {
            IEnergyStorage energyStorage;
            ESShield shield;
            int i = 1;
            ItemStack stack = event.getItemStack();
            Item item = stack.getItem();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (itemId == null || !itemId.getNamespace().equals(ExtraStuck.MODID)) {
                return;
            }
            String tooltip_key = stack.getDescriptionId() + ".tooltip";
            if (I18n.exists((String)tooltip_key)) {
                event.getToolTip().add(i, Component.translatable((String)tooltip_key).withStyle(ChatFormatting.GRAY));
                ++i;
            }
            if (ClientConfig.displayShieldInfo && item instanceof ESShield && (shield = (ESShield)item).hasOnBlock(ESShield.BlockFuncs.DAMAGE)) {
                event.getToolTip().add(i, Component.translatable((String)"extrastuck.shield_damage", (Object[])new Object[]{((Float)stack.get(ESDataComponents.SHIELD_DAMAGE)).intValue()}).withStyle(ChatFormatting.GRAY));
                ++i;
            }
            if ((energyStorage = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(stack, null)) != null) {
                event.getToolTip().add(i, Component.translatable((String)"extrastuck.energy_storage", (Object[])new Object[]{NumberFormat.getInstance().format(energyStorage.getEnergyStored()), NumberFormat.getInstance().format(energyStorage.getMaxEnergyStored())}));
                ++i;
            }
        }
    }

    @EventBusSubscriber(modid="extrastuck", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            for (DeferredItem<Item> shield : ESItems.getShields()) {
                ClientModEvents.addBlocking(shield);
            }
        }

        private static void addBlocking(DeferredItem<Item> item) {
            ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, world, entity, entityid) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(ESEntities.CAPTAIN_JUSTICE_SHIELD.get(), CaptainJusticeShield.CJSRenderer::new);
            event.registerEntityRenderer(ESEntities.FLAME_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/flame.png")));
            event.registerEntityRenderer(ESEntities.NETHER_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/nether.png")));
            event.registerEntityRenderer(ESEntities.CARDBOARD_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/cardboard.png")));
            event.registerEntityRenderer(ESEntities.MISSED_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/missed.png")));
            event.registerEntityRenderer(ESEntities.CANDY_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/candy.png")));
            event.registerEntityRenderer(ESEntities.LIGHTNING_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/lightning.png")));
            event.registerEntityRenderer(ESEntities.EXPLOSIVE_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/explosive.png")));
            event.registerEntityRenderer(ESEntities.IRON_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/iron.png")));
            event.registerEntityRenderer(ESEntities.QUARTZ_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/quartz.png")));
            event.registerEntityRenderer(ESEntities.PRISMARINE_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/prismarine.png")));
            event.registerEntityRenderer(ESEntities.GLASS_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/glass.png")));
            event.registerEntityRenderer(ESEntities.AMETHYST_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/amethyst.png")));
            event.registerEntityRenderer(ESEntities.MINING_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/mining.png")));
            event.registerEntityRenderer(ESEntities.HEALING_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/healing.png")));
            event.registerEntityRenderer(ESEntities.END_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/end.png")));
            event.registerEntityRenderer(ESEntities.TELEPORT_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/teleport.png")));
            event.registerEntityRenderer(ESEntities.DRAGON_ARROW.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/arrow/dragon.png")));
            event.registerEntityRenderer(ESEntities.HANDGUN_BULLET.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/bullet/handgun.png")));
            event.registerEntityRenderer(ESEntities.HEAVY_HANDGUN_BULLET.get(), c -> new ESArrowRenderer(c, ExtraStuck.modid("textures/entity/bullet/heavy_handgun.png")));
            event.registerEntityRenderer(ESEntities.ITEM_BULLET.get(), c -> new ThrownItemRenderer(c));
        }

        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CaptainJusticeShield.CJSModel.LAYER_LOCATION, CaptainJusticeShield.CJSModel::createLayer);
        }

        @SubscribeEvent
        public static void registerExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem(new IClientItemExtensions(){

                public HumanoidModel<?> getHumanoidArmorModel(@Nonnull LivingEntity livingEntity, @Nonnull ItemStack itemStack, @Nonnull EquipmentSlot equipmentSlot, @Nonnull HumanoidModel<?> original) {
                    return new HumanoidModel(HeavyBootsModel.createBodyLayer().bakeRoot());
                }
            }, new Holder[]{ESItems.HEAVY_BOOTS});
        }
    }
}

