/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.blockentities;

import com.medsal15.blockentities.ESBlockEntities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class CardOreBlockEntity
extends BlockEntity
implements IItemHandler {
    private ItemStack stored = ItemStack.EMPTY;
    public static final String ITEM_STORED = "stored";

    public CardOreBlockEntity(BlockPos pos, BlockState state) {
        super(ESBlockEntities.CARD_ORE.get(), pos, state);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(ITEM_STORED, this.stored.saveOptional(registries));
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.stored = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(ITEM_STORED));
    }

    public int getSlots() {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stored;
    }

    public int getSlotLimit(int slot) {
        if (!this.stored.isEmpty()) {
            return this.stored.getMaxStackSize();
        }
        return 99;
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (ItemStack.isSameItemSameComponents((ItemStack)this.stored, (ItemStack)stack)) {
            int sum = stack.getCount() + this.stored.getCount();
            int leftover = 0;
            if (sum > this.stored.getMaxStackSize()) {
                leftover = sum - this.stored.getMaxStackSize();
            }
            if (!simulate) {
                this.stored.setCount(Math.min(sum, this.stored.getMaxStackSize()));
                stack.setCount(leftover);
            }
            if (leftover == 0) {
                return ItemStack.EMPTY;
            }
            return stack;
        }
        if (this.stored.isEmpty()) {
            if (!simulate) {
                this.stored = stack;
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }
}

