/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.compat.patchouli;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.client.util.GuiUtil;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class ComponentGristSet
implements ICustomComponent {
    private transient int x;
    private transient int y;
    private transient GristSet gristSet = GristSet.EMPTY;
    String grist = "";
    IVariable item = IVariable.empty();

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registriesProvider) {
        if (!this.item.equals((Object)IVariable.empty())) {
            IVariable var = (IVariable)lookup.apply(this.item);
            ItemStack stack = (ItemStack)var.as(ItemStack.class);
            ClientLevel level = Minecraft.getInstance().level;
            if (!stack.isEmpty() && level != null) {
                this.gristSet = GristCostRecipe.findCostForItem((ItemStack)stack, null, (boolean)true, (Level)level);
            }
            return;
        }
        String givenGrist = ((IVariable)lookup.apply(IVariable.wrap((String)this.grist, (HolderLookup.Provider)registriesProvider))).asString();
        MutableGristSet set = MutableGristSet.newDefault();
        for (String entry : givenGrist.split(",")) {
            ResourceLocation id;
            GristType grist;
            String[] split = entry.split("#", 2);
            if (split.length < 2 || (grist = (GristType)GristTypes.REGISTRY.get(id = ResourceLocation.tryParse((String)split[0]))) == null) continue;
            int amount = Integer.parseInt(split[1]);
            set.add(grist, (long)amount);
        }
        this.gristSet = set.asImmutable();
    }

    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        GuiUtil.drawGristBoard((GuiGraphics)graphics, (GristSet)this.gristSet, (GuiUtil.GristboardMode)GuiUtil.GristboardMode.LARGE_ALCHEMITER, (int)this.x, (int)this.y, (Font)font);
    }
}

